/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite;

import java.io.File;
import java.nio.ByteBuffer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.tensorflow.lite.InterpreterApi;
import org.tensorflow.lite.InterpreterFactoryApi;
import org.tensorflow.lite.InterpreterImpl;
import org.tensorflow.lite.TensorFlowLite;
import org.tensorflow.lite.annotations.UsedByReflection;
import org.tensorflow.lite.nnapi.NnApiDelegate;
import org.tensorflow.lite.nnapi.NnApiDelegateImpl;

@UsedByReflection(value="InterpreterFactory.java")
class InterpreterFactoryImpl
implements InterpreterFactoryApi {
    public InterpreterApi create(@NonNull File modelFile, InterpreterApi.Options options) {
        return new InterpreterImpl(modelFile, options == null ? null : new InterpreterImpl.Options(options));
    }

    public InterpreterApi create(@NonNull ByteBuffer byteBuffer, InterpreterApi.Options options) {
        return new InterpreterImpl(byteBuffer, options == null ? null : new InterpreterImpl.Options(options));
    }

    public String runtimeVersion() {
        TensorFlowLite.init();
        return InterpreterFactoryImpl.nativeRuntimeVersion();
    }

    public String schemaVersion() {
        TensorFlowLite.init();
        return InterpreterFactoryImpl.nativeSchemaVersion();
    }

    public NnApiDelegate.PrivateInterface createNnApiDelegateImpl(NnApiDelegate.Options options) {
        return new NnApiDelegateImpl(options);
    }

    private static native String nativeRuntimeVersion();

    private static native String nativeSchemaVersion();
}

