/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.task.core.vision;

import android.graphics.Rect;
import com.google.auto.value.AutoValue;
import org.tensorflow.lite.task.core.vision.AutoValue_ImageProcessingOptions;

@AutoValue
public abstract class ImageProcessingOptions {
    private static final Rect defaultRoi = new Rect();
    private static final Orientation DEFAULT_ORIENTATION = Orientation.TOP_LEFT;

    public abstract Rect getRoi();

    public abstract Orientation getOrientation();

    public static Builder builder() {
        return new AutoValue_ImageProcessingOptions.Builder().setRoi(defaultRoi).setOrientation(DEFAULT_ORIENTATION);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setRoi(Rect var1);

        public abstract Builder setOrientation(Orientation var1);

        abstract Rect getRoi();

        abstract ImageProcessingOptions autoBuild();

        public ImageProcessingOptions build() {
            this.setRoi(new Rect(this.getRoi()));
            return this.autoBuild();
        }
    }

    public static enum Orientation {
        TOP_LEFT(0),
        TOP_RIGHT(1),
        BOTTOM_RIGHT(2),
        BOTTOM_LEFT(3),
        LEFT_TOP(4),
        RIGHT_TOP(5),
        RIGHT_BOTTOM(6),
        LEFT_BOTTOM(7);

        private final int value;

        private Orientation(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

