/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * A Reader that outputs rows from a BigQuery table as tensorflow Examples.
 */
@Operator
public final class BigQueryReader extends PrimitiveOp implements Operand<String> {
  
  /**
   * Optional attributes for {@link org.tensorflow.op.core.BigQueryReader}
   */
  public static class Options {
    
    /**
     * @param container If non-empty, this reader is placed in the given container.
     * Otherwise, a default container is used.
     */
    public Options container(String container) {
      this.container = container;
      return this;
    }
    
    /**
     * @param sharedName If non-empty, this reader is named in the given bucket
     * with this shared_name. Otherwise, the node name is used instead.
     */
    public Options sharedName(String sharedName) {
      this.sharedName = sharedName;
      return this;
    }
    
    /**
     * @param testEndPoint Do not use. For testing purposes only.
     */
    public Options testEndPoint(String testEndPoint) {
      this.testEndPoint = testEndPoint;
      return this;
    }
    
    private String container;
    private String sharedName;
    private String testEndPoint;
    
    private Options() {
    }
  }
  
  /**
   * Factory method to create a class to wrap a new BigQueryReader operation to the graph.
   * 
   * @param scope current graph scope
   * @param projectId GCP project ID.
   * @param datasetId BigQuery Dataset ID.
   * @param tableId Table to read.
   * @param columns List of columns to read. Leave empty to read all columns.
   * @param timestampMillis Table snapshot timestamp in millis since epoch. Relative
   * (negative or zero) snapshot times are not allowed. For more details, see
   * 'Table Decorators' in BigQuery docs.
   * @param options carries optional attributes values
   * @return a new instance of BigQueryReader
   */
  public static BigQueryReader create(Scope scope, String projectId, String datasetId, String tableId, List<String> columns, Long timestampMillis, Options... options) {
    OperationBuilder opBuilder = scope.graph().opBuilder("BigQueryReader", scope.makeOpName("BigQueryReader"));
    opBuilder.setAttr("project_id", projectId);
    opBuilder.setAttr("dataset_id", datasetId);
    opBuilder.setAttr("table_id", tableId);
    String[] columnsArray = new String[columns.size()];
    for (int i = 0; i < columnsArray.length; ++i) {
      columnsArray[i] = columns.get(i);
    }
    opBuilder.setAttr("columns", columnsArray);
    opBuilder.setAttr("timestamp_millis", timestampMillis);
    if (options != null) {
      for (Options opts : options) {
        if (opts.container != null) {
          opBuilder.setAttr("container", opts.container);
        }
        if (opts.sharedName != null) {
          opBuilder.setAttr("shared_name", opts.sharedName);
        }
        if (opts.testEndPoint != null) {
          opBuilder.setAttr("test_end_point", opts.testEndPoint);
        }
      }
    }
    return new BigQueryReader(opBuilder.build());
  }
  
  /**
   * @param container If non-empty, this reader is placed in the given container.
   * Otherwise, a default container is used.
   */
  public static Options container(String container) {
    return new Options().container(container);
  }
  
  /**
   * @param sharedName If non-empty, this reader is named in the given bucket
   * with this shared_name. Otherwise, the node name is used instead.
   */
  public static Options sharedName(String sharedName) {
    return new Options().sharedName(sharedName);
  }
  
  /**
   * @param testEndPoint Do not use. For testing purposes only.
   */
  public static Options testEndPoint(String testEndPoint) {
    return new Options().testEndPoint(testEndPoint);
  }
  
  /**
   * The handle to reference the Reader.
   */
  public Output<String> readerHandle() {
    return readerHandle;
  }
  
  @Override
  public Output<String> asOutput() {
    return readerHandle;
  }
  
  private Output<String> readerHandle;
  
  private BigQueryReader(Operation operation) {
    super(operation);
    int outputIdx = 0;
    readerHandle = operation.output(outputIdx++);
  }
}
