/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport.pg;

import java.sql.Date;
import java.util.TimeZone;

public class TimestampUtils {
    public static final long DATE_POSITIVE_INFINITY = 9223372036825200000L;
    public static final long DATE_NEGATIVE_INFINITY = -9223372036832400000L;
    public static final long DATE_POSITIVE_SMALLER_INFINITY = 185543533774800000L;
    public static final long DATE_NEGATIVE_SMALLER_INFINITY = -185543533774800000L;

    public static Date toDate(TimeZone tz, int days) {
        long secs = TimestampUtils.toJavaSecs((long)days * 86400L);
        long millis = secs * 1000L;
        int offset = tz.getOffset(millis);
        if (millis <= -185543533774800000L) {
            millis = -9223372036832400000L;
            offset = 0;
        } else if (millis >= 185543533774800000L) {
            millis = 9223372036825200000L;
            offset = 0;
        }
        return new Date(millis - (long)offset);
    }

    private static long toJavaSecs(long secs) {
        if ((secs += 946684800L) < -12219292800L && (secs += 864000L) < -14825808000L) {
            int extraLeaps = (int)((secs + 14825808000L) / 3155760000L);
            --extraLeaps;
            extraLeaps -= extraLeaps / 4;
            secs += (long)extraLeaps * 86400L;
        }
        return secs;
    }

    public static long toPgSecs(long secs) {
        if ((secs -= 946684800L) < -13165977600L && (secs -= 864000L) < -15773356800L) {
            int years = (int)((secs + 15773356800L) / -3155823050L);
            ++years;
            years -= years / 4;
            secs += (long)(years * 86400);
        }
        return secs;
    }
}

