/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.teiid.core.BundleUtil;
import org.teiid.logging.LogManager;
import org.teiid.net.socket.ObjectChannel;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.transport.ChannelListener;
import org.teiid.transport.SocketClientInstance;

@ChannelHandler.Sharable
public class SSLAwareChannelHandler
extends ChannelDuplexHandler {
    private final ChannelListener.ChannelListenerFactory listenerFactory;
    private Map<Channel, ChannelListener> listeners = new ConcurrentHashMap<Channel, ChannelListener>();
    private AtomicLong objectsRead = new AtomicLong(0L);
    private AtomicLong objectsWritten = new AtomicLong(0L);
    private volatile int maxChannels;
    private ChannelFutureListener completionListener = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture arg0) throws Exception {
            if (arg0.isSuccess()) {
                SSLAwareChannelHandler.this.objectsWritten.getAndIncrement();
            } else if (arg0.cause() != null) {
                SSLAwareChannelHandler.this.writeExceptionCaught(arg0.channel(), arg0.cause());
            }
        }
    };

    public SSLAwareChannelHandler(ChannelListener.ChannelListenerFactory listenerFactory) {
        this.listenerFactory = listenerFactory;
    }

    public void channelActive(final ChannelHandlerContext ctx) throws Exception {
        ChannelListener listener = this.listenerFactory.createChannelListener(new ObjectChannelImpl(ctx.channel()));
        this.listeners.put(ctx.channel(), listener);
        this.maxChannels = Math.max(this.maxChannels, this.listeners.size());
        SslHandler sslHandler = (SslHandler)ctx.pipeline().get(SslHandler.class);
        if (sslHandler != null) {
            sslHandler.handshakeFuture().addListener((GenericFutureListener)new GenericFutureListener<DefaultPromise<Channel>>(){

                public void operationComplete(DefaultPromise<Channel> future) throws Exception {
                    SSLAwareChannelHandler.this.onConnection(ctx.channel());
                }
            });
        } else {
            this.onConnection(ctx.channel());
        }
    }

    private void onConnection(Channel channel) throws Exception {
        ChannelListener listener = this.listeners.get(channel);
        if (listener != null) {
            listener.onConnection();
        }
    }

    private void writeExceptionCaught(Channel channel, Throwable cause) {
        ChannelListener listener = this.listeners.get(channel);
        if (listener != null) {
            listener.exceptionOccurred(cause);
        } else {
            int level = SocketClientInstance.getLevel(cause);
            LogManager.log((int)level, (String)"org.teiid.TRANSPORT", (Throwable)(LogManager.isMessageToBeRecorded((String)"org.teiid.TRANSPORT", (int)5) || level < 3 ? cause : null), (Object[])new Object[]{RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40114, new Object[]{cause.getMessage()})});
            channel.close();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.writeExceptionCaught(ctx.channel(), cause);
    }

    public void messageReceived(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.objectsRead.getAndIncrement();
        ChannelListener listener = this.listeners.get(ctx.channel());
        if (listener != null) {
            listener.receivedMessage(msg);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.messageReceived(ctx, msg);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ChannelListener listener = this.listeners.remove(ctx.channel());
        if (listener != null) {
            LogManager.logDetail((String)"org.teiid.TRANSPORT", (Object)RuntimePlugin.Util.getString("SSLAwareChannelHandler.channel_closed"));
            listener.disconnected();
        }
    }

    public long getObjectsRead() {
        return this.objectsRead.get();
    }

    public long getObjectsWritten() {
        return this.objectsWritten.get();
    }

    public int getConnectedChannels() {
        return this.listeners.size();
    }

    public int getMaxConnectedChannels() {
        return this.maxChannels;
    }

    public class ObjectChannelImpl
    implements ObjectChannel {
        private final Channel channel;

        public ObjectChannelImpl(Channel channel) {
            this.channel = channel;
        }

        public void close() {
            this.channel.close();
        }

        public boolean isOpen() {
            return this.channel.isOpen();
        }

        public SocketAddress getRemoteAddress() {
            return this.channel.remoteAddress();
        }

        public InetAddress getLocalAddress() {
            throw new UnsupportedOperationException();
        }

        public Object read() throws IOException, ClassNotFoundException {
            throw new UnsupportedOperationException();
        }

        public synchronized Future<?> write(final Object msg) {
            return this.channel.eventLoop().submit(new Runnable(){

                @Override
                public void run() {
                    ChannelFuture future = ObjectChannelImpl.this.channel.writeAndFlush(msg);
                    future.addListener((GenericFutureListener)SSLAwareChannelHandler.this.completionListener);
                }
            });
        }
    }
}

