/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.teiid.CommandContext;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.AbstractGeospatialType;
import org.teiid.core.types.ArrayImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.GeographyType;
import org.teiid.core.types.GeometryType;
import org.teiid.core.types.TransformationException;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.core.util.StringUtil;
import org.teiid.jdbc.TeiidConnection;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.odbc.ODBCServerRemoteImpl;
import org.teiid.query.function.GeometryFunctionMethods;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.parser.ParseException;
import org.teiid.query.parser.SQLParserUtil;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.symbol.GroupSymbol;

public class PgCatalogMetadataStore
extends MetadataFactory {
    private static final long serialVersionUID = 2158418324376966987L;
    public static final String POSTGIS_LIB_VERSION = "2.0.0 USE_GEOS=0 USE_PROJ=1 USE_STATS=0";
    public static final String POSTGRESQL_VERSION = PropertiesUtils.getHierarchicalProperty((String)"org.teiid.pgVersion", (String)"PostgreSQL 8.2");
    public static final String TYPMOD = "(CASE WHEN (t1.DataType = 'bigdecimal' OR t1.DataType = 'biginteger') THEN 4+(65536*(case when (t1.Precision>32767) then 32767 else t1.Precision end)+(case when (t1.Scale>32767) then 32767 else t1.Scale end)) WHEN (t1.DataType = 'string' OR t1.DataType = 'char') THEN (CASE WHEN (t1.Length <= 2147483643) THEN 4+ t1.Length ELSE 2147483647 END) ELSE -1 END)";

    public PgCatalogMetadataStore(String modelName, Map<String, Datatype> dataTypes) {
        super(modelName, (Object)1, modelName, dataTypes, new Properties(), null);
        this.add_pg_namespace();
        this.add_pg_class();
        this.add_pg_attribute();
        this.add_pg_type();
        this.add_pg_index();
        this.add_pg_am();
        this.add_pg_proc();
        this.add_pg_trigger();
        this.add_pg_attrdef();
        this.add_pg_database();
        this.add_pg_user();
        this.add_matpg_datatype();
        this.add_pg_description();
        this.add_pg_prepared_xacts();
        this.add_pg_inherits();
        this.add_pg_stats();
        this.add_pg_constraint();
        this.add_infoSchemaTables();
        this.add_infoSchemaViews();
        this.add_infoSchemaColumns();
        this.add_infoSchemaReferentialConstraints();
        this.add_infoSchemaKeyColumnUsage();
        this.add_infoSchemaTableConstraints();
        this.addFunction("regClass", "regclass").setNullOnNull(true);
        this.addFunction("encode", "encode").setPushdown(FunctionMethod.PushDown.CAN_PUSHDOWN);
        this.addFunction("objDescription", "obj_description");
        this.addFunction("objDescription2", "obj_description");
        this.addFunction("hasSchemaPrivilege", "has_schema_privilege").setNullOnNull(true);
        this.addFunction("hasTablePrivilege", "has_table_privilege").setNullOnNull(true);
        this.addFunction("formatType", "format_type");
        this.addFunction("currentSchema", "current_schema");
        this.addFunction("getUserById", "pg_get_userbyid");
        this.addFunction("colDescription", "col_description");
        this.addFunction("pgHasRole", "pg_has_role");
        this.addFunction("asBinary2", "ST_asBinary");
        this.addFunction("asBinary3", "ST_asBinary");
        this.addFunction("postgisLibVersion", "public.PostGIS_Lib_Version");
        this.addFunction("postgisGeosVersion", "public.postgis_geos_version");
        this.addFunction("postgisProjVersion", "public.postgis_proj_version");
        this.addFunction("postgisVersion", "public.postgis_version");
        this.addFunction("hasPerm", "has_function_privilege");
        this.addFunction("getExpr2", "pg_get_expr");
        this.addFunction("getExpr3", "pg_get_expr");
        this.addFunction("pg_table_is_visible", "pg_table_is_visible");
        this.addFunction("pg_get_constraintdef", "pg_get_constraintdef");
        this.addFunction("pg_type_is_visible", "pg_type_is_visible");
        this.addFunction("pg_encoding_to_char", "pg_encoding_to_char");
        FunctionMethod func = this.addFunction("asPGVector", "asPGVector");
        func.setProperty("teiid:pass-through-type", Boolean.TRUE.toString());
        this.addFunction("getOid", "getOid").setNullOnNull(true);
        this.addFunction("version", "version");
        func = this.addFunction("pg_client_encoding", "pg_client_encoding");
        func.setDeterminism(FunctionMethod.Determinism.COMMAND_DETERMINISTIC);
        this.addFunction("current_schemas", "current_schemas");
        this.addFunction("pg_get_indexdef", "pg_get_indexdef");
        this.addFunction("array_to_string", "array_to_string").setNullOnNull(true);
    }

    private Table add_pg_constraint() {
        Table t = this.createView("pg_constraint");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("conname", "string", (ColumnSet)t);
        this.addColumn("connamespace", "integer", (ColumnSet)t);
        this.addColumn("contype", "string", (ColumnSet)t);
        this.addColumn("condeferrable", "boolean", (ColumnSet)t);
        this.addColumn("condeferred", "boolean", (ColumnSet)t);
        this.addColumn("consrc", "string", (ColumnSet)t);
        this.addColumn("conrelid", "integer", (ColumnSet)t);
        this.addColumn("confrelid", "integer", (ColumnSet)t);
        this.addColumn("conkey", DataTypeManager.getDataTypeName((Class)DataTypeManager.getArrayType((Class)DataTypeManager.DefaultDataClasses.SHORT)), (ColumnSet)t);
        String transformation = "SELECT pg_catalog.getOid(UID) as oid, name as conname, pg_catalog.getOid(SchemaUID), lower(left(Type, 1)) as contype, false as condeferrable, false as condeferred, null as consrc, pg_catalog.getOid(TableUID) as conrelid, pg_catalog.getOid(RefTableUID) as confrelid, ColPositions as conkey FROM Sys.Keys WHERE Type in ('Primary', 'Unique', 'Foreign')";
        t.setSelectTransformation(transformation);
        return t;
    }

    private void add_pg_prepared_xacts() {
        Table t = this.createView("pg_prepared_xacts");
        this.addColumn("transaction", "string", (ColumnSet)t);
        this.addColumn("gid", "string", (ColumnSet)t);
        this.addColumn("owner", "string", (ColumnSet)t);
        this.addColumn("database", "string", (ColumnSet)t);
        String transformation = "SELECT null, null, null, null from SYS.Tables WHERE 1=2";
        t.setSelectTransformation(transformation);
    }

    private void add_pg_inherits() {
        Table t = this.createView("pg_inherits");
        this.addColumn("inhrelid", "integer", (ColumnSet)t);
        this.addColumn("inhparent", "integer", (ColumnSet)t);
        this.addColumn("inhseqno", "integer", (ColumnSet)t);
        String transformation = "SELECT null, null, null from SYS.Tables WHERE 1=2";
        t.setSelectTransformation(transformation);
    }

    private void add_pg_stats() {
        Table t = this.createView("pg_stats");
        this.addColumn("schemaname", "string", (ColumnSet)t);
        this.addColumn("tablename", "string", (ColumnSet)t);
        this.addColumn("attname", "string", (ColumnSet)t);
        String transformation = "SELECT null, null, null from SYS.Tables WHERE 1=2";
        t.setSelectTransformation(transformation);
    }

    private Table createView(String name) {
        Table t = this.addTable(name);
        t.setSystem(true);
        t.setSupportsUpdate(false);
        t.setVirtual(true);
        t.setTableType(Table.Type.Table);
        return t;
    }

    private Table add_pg_description() {
        Table t = this.createView("pg_description");
        this.addColumn("objoid", "integer", (ColumnSet)t);
        this.addColumn("classoid", "integer", (ColumnSet)t);
        this.addColumn("objsubid", "integer", (ColumnSet)t);
        this.addColumn("description", "string", (ColumnSet)t);
        String transformation = "SELECT 0, null, null, null";
        t.setSelectTransformation(transformation);
        return t;
    }

    private Table add_pg_am() {
        Table t = this.createView("pg_am");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("amname", "string", (ColumnSet)t);
        String transformation = "SELECT 0 as oid, 'btree' as amname";
        t.setSelectTransformation(transformation);
        return t;
    }

    private Table add_pg_attrdef() {
        Table t = this.createView("pg_attrdef");
        this.addColumn("adrelid", "integer", (ColumnSet)t);
        this.addColumn("adnum", "short", (ColumnSet)t);
        this.addColumn("adbin", "string", (ColumnSet)t);
        this.addColumn("adsrc", "string", (ColumnSet)t);
        String transformation = "SELECT pg_catalog.getOid(t1.tableuid) as adrelid, convert(t1.Position, short) as adnum, case when t1.IsAutoIncremented then 'nextval(' else t1.DefaultValue end as adbin, case when t1.IsAutoIncremented then 'nextval(' else t1.DefaultValue end as adsrc FROM SYS.Columns as t1";
        t.setSelectTransformation(transformation);
        return t;
    }

    private Table add_pg_attribute() {
        Table t = this.createView("pg_attribute");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("attrelid", "integer", (ColumnSet)t);
        this.addColumn("attname", "string", (ColumnSet)t);
        this.addColumn("atttypid", "integer", (ColumnSet)t);
        this.addColumn("attlen", "short", (ColumnSet)t);
        this.addColumn("attnum", "short", (ColumnSet)t);
        this.addColumn("atttypmod", "integer", (ColumnSet)t);
        this.addColumn("attnotnull", "boolean", (ColumnSet)t);
        this.addColumn("attisdropped", "boolean", (ColumnSet)t);
        this.addColumn("atthasdef", "boolean", (ColumnSet)t);
        this.addPrimaryKey("pk_pg_attr", Arrays.asList("oid"), t);
        String transformation = "SELECT pg_catalog.getOid(t1.uid) as oid, pg_catalog.getOid(t1.TableUID) as attrelid, t1.Name as attname, pt.oid as atttypid,pt.typlen as attlen, convert(t1.Position, short) as attnum, (CASE WHEN (t1.DataType = 'bigdecimal' OR t1.DataType = 'biginteger') THEN 4+(65536*(case when (t1.Precision>32767) then 32767 else t1.Precision end)+(case when (t1.Scale>32767) then 32767 else t1.Scale end)) WHEN (t1.DataType = 'string' OR t1.DataType = 'char') THEN (CASE WHEN (t1.Length <= 2147483643) THEN 4+ t1.Length ELSE 2147483647 END) ELSE -1 END) as atttypmod, CASE WHEN (t1.NullType = 'No Nulls') THEN true ELSE false END as attnotnull, false as attisdropped, false as atthasdef FROM SYS.Columns as t1 LEFT OUTER JOIN pg_catalog.matpg_datatype pt ON t1.DataType = pt.Name UNION ALL SELECT pg_catalog.getOid(kc.uid) + kc.position as oid, pg_catalog.getOid(kc.uid) as attrelid, t1.Name as attname, pt.oid as atttypid,pt.typlen as attlen, convert(kc.Position, short) as attnum, (CASE WHEN (t1.DataType = 'bigdecimal' OR t1.DataType = 'biginteger') THEN 4+(65536*(case when (t1.Precision>32767) then 32767 else t1.Precision end)+(case when (t1.Scale>32767) then 32767 else t1.Scale end)) WHEN (t1.DataType = 'string' OR t1.DataType = 'char') THEN (CASE WHEN (t1.Length <= 2147483643) THEN 4+ t1.Length ELSE 2147483647 END) ELSE -1 END) as atttypmod, CASE WHEN (t1.NullType = 'No Nulls') THEN true ELSE false END as attnotnull, false as attisdropped, false as atthasdef FROM (SYS.KeyColumns as kc INNER JOIN SYS.Columns as t1 ON kc.SchemaName = t1.SchemaName AND kc.TableName = t1.TableName AND kc.Name = t1.Name) LEFT OUTER JOIN pg_catalog.matpg_datatype pt ON t1.DataType = pt.Name WHERE kc.keytype in ('Primary', 'Unique', 'Index')";
        t.setSelectTransformation(transformation);
        return t;
    }

    private Table add_pg_class() {
        Table t = this.createView("pg_class");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("relname", "string", (ColumnSet)t);
        this.addColumn("relnamespace", "integer", (ColumnSet)t);
        this.addColumn("relkind", "char", (ColumnSet)t);
        this.addColumn("relowner", "integer", (ColumnSet)t);
        this.addColumn("relam", "integer", (ColumnSet)t);
        this.addColumn("reltuples", "float", (ColumnSet)t);
        this.addColumn("relpages", "integer", (ColumnSet)t);
        this.addColumn("relhasrules", "boolean", (ColumnSet)t);
        this.addColumn("relhasoids", "boolean", (ColumnSet)t);
        this.addColumn("relnspname", "string", (ColumnSet)t);
        this.addColumn("reloptions", DataTypeManager.getDataTypeName((Class)DataTypeManager.getArrayType((Class)DataTypeManager.DefaultDataClasses.STRING)), (ColumnSet)t);
        this.addColumn("relacl", "object[]", (ColumnSet)t);
        this.addPrimaryKey("pk_pg_class", Arrays.asList("oid"), t);
        String transformation = "SELECT pg_catalog.getOid(t1.uid) as oid, t1.name as relname, pg_catalog.getOid(t1.SchemaUID) as relnamespace, convert((CASE t1.isPhysical WHEN true THEN 'r' ELSE 'v' END), char) as relkind,0 as relowner, 0 as relam, convert(0, float) as reltuples, 0 as relpages, false as relhasrules, false as relhasoids, t1.SchemaName as relnspname, null as reloptions, null as relacl FROM SYS.Tables t1 UNION ALL SELECT pg_catalog.getOid(t1.uid) as oid, t1.name as relname, pg_catalog.getOid(uid) as relnamespace, convert('i', char) as relkind,0 as relowner, 0 as relam, convert(0, float) as reltuples, 0 as relpages, false as relhasrules, false as relhasoids, t1.SchemaName as relnspname, null as reloptions, null as relacl FROM SYS.Keys t1 WHERE t1.type in ('Primary', 'Unique', 'Index')";
        t.setSelectTransformation(transformation);
        return t;
    }

    private Table add_pg_index() {
        Table t = this.createView("pg_index");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("indexrelid", "integer", (ColumnSet)t);
        this.addColumn("indrelid", "integer", (ColumnSet)t);
        this.addColumn("indnatts", "short", (ColumnSet)t);
        this.addColumn("indisclustered", "boolean", (ColumnSet)t);
        this.addColumn("indisunique", "boolean", (ColumnSet)t);
        this.addColumn("indisprimary", "boolean", (ColumnSet)t);
        Column c = this.addColumn("indkey", DataTypeManager.getDataTypeName((Class)DataTypeManager.getArrayType((Class)DataTypeManager.DefaultDataClasses.SHORT)), (ColumnSet)t);
        c.setProperty("pg_type:oid", String.valueOf(22));
        this.addColumn("indexprs", "string", (ColumnSet)t);
        this.addColumn("indpred", "string", (ColumnSet)t);
        this.addColumn("indkey_names", DataTypeManager.getDataTypeName((Class)DataTypeManager.getArrayType((Class)DataTypeManager.DefaultDataClasses.STRING)), (ColumnSet)t);
        this.addPrimaryKey("pk_pg_index", Arrays.asList("indexrelid"), t);
        String transformation = "SELECT pg_catalog.getOid(t1.uid) as oid, pg_catalog.getOid(t1.uid) as indexrelid, pg_catalog.getOid(t1.TableUID) as indrelid, cast(ARRAY_LENGTH(ColPositions) as short) as indnatts, false indisclustered, (CASE WHEN t1.Type in ('Unique', 'Primary') THEN true ELSE false END) as indisunique, (CASE t1.Type WHEN 'Primary' THEN true ELSE false END) as indisprimary, asPGVector(ColPositions) as indkey, null as indexprs, null as indpred, ColNames as indkey_names FROM Sys.Keys as t1";
        t.setSelectTransformation(transformation);
        return t;
    }

    private Table add_pg_namespace() {
        Table t = this.createView("pg_namespace");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("nspname", "string", (ColumnSet)t);
        this.addColumn("nspowner", "integer", (ColumnSet)t);
        String transformation = "SELECT pg_catalog.getOid(uid) as oid, t1.Name as nspname, 0 as nspowner FROM SYS.Schemas as t1";
        t.setSelectTransformation(transformation);
        return t;
    }

    private Table add_pg_proc() {
        Table t = this.createView("pg_proc");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("proname", "string", (ColumnSet)t);
        this.addColumn("proretset", "boolean", (ColumnSet)t);
        this.addColumn("prorettype", "integer", (ColumnSet)t);
        this.addColumn("pronargs", "short", (ColumnSet)t);
        Column c = this.addColumn("proargtypes", DataTypeManager.getDataTypeName((Class)DataTypeManager.getArrayType((Class)DataTypeManager.DefaultDataClasses.INTEGER)), (ColumnSet)t);
        c.setProperty("pg_type:oid", String.valueOf(30));
        c = this.addColumn("proargnames", DataTypeManager.getDataTypeName((Class)DataTypeManager.getArrayType((Class)DataTypeManager.DefaultDataClasses.STRING)), (ColumnSet)t);
        c.setProperty("pg_type:oid", String.valueOf(1009));
        c = this.addColumn("proargmodes", DataTypeManager.getDataTypeName((Class)DataTypeManager.getArrayType((Class)DataTypeManager.DefaultDataClasses.CHAR)), (ColumnSet)t);
        c.setProperty("pg_type:oid", String.valueOf(1002));
        c = this.addColumn("proallargtypes", DataTypeManager.getDataTypeName((Class)DataTypeManager.getArrayType((Class)DataTypeManager.DefaultDataClasses.INTEGER)), (ColumnSet)t);
        c.setProperty("pg_type:oid", String.valueOf(1028));
        this.addColumn("pronamespace", "integer", (ColumnSet)t);
        this.addPrimaryKey("pk_pg_proc", Arrays.asList("oid"), t);
        String transformation = this.procQuery("Procedure") + " UNION ALL " + this.procQuery("Function") + " WHERE t1.SchemaName = 'pg_catalog'";
        transformation = transformation + " union all SELECT typreceive as oid, case when kind = 'a' then 'array_recv' else kind end as proname, false as proretset, oid as prorettype, cast(case when kind = 'a' then 3 else 1 end as short) as pronargs,case when kind = 'a' then (2281, 26, 23) else (2281,) end as proargtypes,null as proargnames, null as proargmodes, null as proallargtypes,(select oid from pg_catalog.pg_namespace where nspname = 'pg_catalog') as pronamespace FROM(SELECT typreceive, case when typelem <> 0 and typname like '\\__%' escape '\\' then 'a' else typname || 'recv' end as kind, oid from pg_catalog.pg_type where typname not in ('internal', 'anyelement')) v";
        t.setSelectTransformation(transformation);
        return t;
    }

    private String procQuery(String type) {
        return "SELECT pg_catalog.getOid(t1.uid) as oid, t1.Name as proname, (SELECT (CASE WHEN count(pp.Type)>0 THEN true else false END) as x FROM SYS." + type + "Params pp WHERE pp." + type + "Name = t1.Name AND pp.SchemaName = t1.SchemaName AND pp." + type + "UID = t1.UID and pp.Type='ResultSet') as proretset, CASE WHEN (SELECT count(dt.oid) FROM SYS." + type + "Params pp, pg_catalog.matpg_datatype dt WHERE pp." + type + "Name = t1.Name AND pp.SchemaName = t1.SchemaName AND pp." + type + "UID = t1.UID AND pp.Type IN ('ReturnValue', 'ResultSet') AND dt.Name = pp.DataType) = 0 THEN (select oid from pg_catalog.pg_type WHERE typname = 'void') WHEN (SELECT count(dt.oid) FROM SYS." + type + "Params pp, pg_catalog.matpg_datatype dt WHERE pp." + type + "Name = t1.Name AND pp.SchemaName = t1.SchemaName AND pp." + type + "UID = t1.UID AND pp.Type = 'ResultSet' AND dt.Name = pp.DataType) > 0 THEN (select oid from pg_catalog.pg_type WHERE typname = 'record') ELSE (SELECT dt.oid FROM SYS." + type + "Params pp, pg_catalog.matpg_datatype dt WHERE pp." + type + "Name = t1.Name AND pp.SchemaName = t1.SchemaName AND pp." + type + "UID = t1.UID AND pp." + type + "UID = t1.UID AND pp.Type = 'ReturnValue' AND dt.Name = pp.DataType) END as prorettype,  convert((SELECT count(*) FROM SYS." + type + "Params pp WHERE pp." + type + "Name = t1.Name AND pp.SchemaName = t1.SchemaName AND pp." + type + "UID = t1.UID AND pp.Type IN ('In', 'InOut')), short) as pronargs, asPGVector((select " + this.arrayAgg("y.oid", "y.type, y.position") + " FROM (" + this.paramTable("'ResultSet','ReturnValue', 'Out'", type) + ") as y)) as proargtypes, (select " + this.arrayAgg("y.name", "y.type, y.position") + " FROM (SELECT pp.Name as name, pp.position as position, pp.Type as type FROM SYS." + type + "Params pp WHERE pp." + type + "Name = t1.Name AND pp.SchemaName = t1.SchemaName AND pp." + type + "UID = t1.UID AND pp.Type NOT IN ('ReturnValue' )) as y) as proargnames, (select case WHEN count(distinct(y.type)) = 1 THEN null ELSE " + this.arrayAgg("CASE WHEN (y.type ='In') THEN cast('i' as char) WHEN (y.type = 'Out') THEN cast('o' as char) WHEN (y.type = 'InOut') THEN cast('b' as char) WHEN (y.type = 'ResultSet') THEN cast('t' as char) END", "y.type,y.position") + " END FROM (SELECT pp.Type as type, pp.Position as position FROM SYS." + type + "Params pp WHERE pp." + type + "Name = t1.Name AND pp.SchemaName = t1.SchemaName AND pp." + type + "UID = t1.UID AND pp.Type NOT IN ('ReturnValue')) as y) as proargmodes, (select case WHEN count(distinct(y.oid)) = 1 THEN null ELSE " + this.arrayAgg("y.oid", "y.type, y.position") + " END FROM (" + this.paramTable("'ReturnValue'", type) + ") as y) as proallargtypes, pg_catalog.getOid(t1.SchemaUID) as pronamespace FROM SYS." + type + "s as t1";
    }

    private String paramTable(String notIn, String type) {
        return "SELECT case when pp.Type <> 'ResultSet' AND pp.DataType = 'object' then 2283 else dt.oid end as oid, pp.Position as position, pp.Type as type FROM SYS." + type + "Params pp LEFT JOIN pg_catalog.matpg_datatype dt ON pp.DataType=dt.Name WHERE pp." + type + "Name = t1.Name AND pp.SchemaName = t1.SchemaName AND pp." + type + "UID = t1.UID AND pp.Type NOT IN (" + notIn + ")";
    }

    private String arrayAgg(String select, String orderby) {
        return "array_agg(" + select + " ORDER BY " + orderby + ")";
    }

    private Table add_pg_trigger() {
        Table t = this.createView("pg_trigger");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("tgconstrrelid", "integer", (ColumnSet)t);
        this.addColumn("tgfoid", "integer", (ColumnSet)t);
        this.addColumn("tgargs", "integer", (ColumnSet)t);
        this.addColumn("tgnargs", "integer", (ColumnSet)t);
        this.addColumn("tgdeferrable", "boolean", (ColumnSet)t);
        this.addColumn("tginitdeferred", "boolean", (ColumnSet)t);
        this.addColumn("tgconstrname", "string", (ColumnSet)t);
        this.addColumn("tgrelid", "integer", (ColumnSet)t);
        String transformation = "SELECT 1 as oid, 1 as tgconstrrelid, 1 as tgfoid, 1 as tgargs, 1 as tgnargs, false as tgdeferrable, false as tginitdeferred, 'dummy' as tgconstrname, 1 as tgrelid FROM SYS.Tables WHERE 1=2";
        t.setSelectTransformation(transformation);
        return t;
    }

    private Table add_pg_type() {
        Table t = this.createView("pg_type");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("typname", "string", (ColumnSet)t);
        this.addColumn("typnamespace", "integer", (ColumnSet)t);
        this.addColumn("typlen", "short", (ColumnSet)t);
        this.addColumn("typtype", "char", (ColumnSet)t);
        this.addColumn("typnotnull", "boolean", (ColumnSet)t);
        this.addColumn("typbasetype", "integer", (ColumnSet)t);
        this.addColumn("typtypmod", "integer", (ColumnSet)t);
        this.addColumn("typdelim", "char", (ColumnSet)t);
        this.addColumn("typrelid", "integer", (ColumnSet)t);
        this.addColumn("typelem", "integer", (ColumnSet)t);
        this.addColumn("typinput", "integer", (ColumnSet)t);
        this.addColumn("typreceive", "integer", (ColumnSet)t);
        this.addColumn("typdefault", "string", (ColumnSet)t);
        this.addColumn("teiid_name", "string", (ColumnSet)t);
        String transformation = "select oid, typname, (SELECT pg_catalog.getOid(uid) FROM SYS.Schemas where Name = 'SYS') as typnamespace, typlen, typtype, false as typnotnull, typbasetype, typtypmod, cast(',' as char) as typdelim, typrelid, typelem, null as typinput, 2147483647 - cast(row_number() over (order by typname) as integer) as typreceive, null as typdfault, teiid_name from texttable('16,bool,1,b,0,-1,0,0,boolean\n17,bytea,-1,b,0,-1,0,0,blob\n18,char,1,b,0,-1,0,0,\n1043,varchar,-1,b,0,-1,0,0,string\n25,text,-1,b,0,-1,0,0,clob\n1042,bpchar,-1,b,0,-1,0,0,\n21,int2,2,b,0,-1,0,0,short\n20,int8,8,b,0,-1,0,0,long\n23,int4,4,b,0,-1,0,0,integer\n26,oid,4,b,0,-1,0,0,\n700,float4,4,b,0,-1,0,0,float\n701,float8,8,b,0,-1,0,0,double\n705,unknown,-2,b,0,-1,0,0,object\n1082,date,4,b,0,-1,0,0,date\n1083,time,8,b,0,-1,0,0,time\n1114,timestamp,8,b,0,-1,0,0,timestamp\n1700,numeric,-1,b,0,-1,0,0,bigdecimal\n142,xml,-1,b,0,-1,0,0,xml\n14939,lo,-1,b,0,-1,0,0,\n3803,json,-1,b,0,-1,0,0,json\n32816,geometry,-1,b,0,-1,0,0,geometry\n33454,geography,-1,b,0,-1,0,0,geography\n2278,void,4,p,0,-1,0,0,\n2249,record,-1,p,0,-1,0,0,\n30,oidvector,-1,b,0,-1,0,26,\n1000,_bool,-1,b,0,-1,0,16,boolean[]\n1001,_bytea,-1,b,0,-1,0,17,blob[]\n1002,_char,-1,b,0,-1,0,18,\n1005,_int2,-1,b,0,-1,0,21,short[]\n1007,_int4,-1,b,0,-1,0,23,integer[]\n1009,_text,-1,b,0,-1,0,25,clob[]\n1028,_oid,-1,b,0,-1,0,26,\n1014,_bpchar,-1,b,0,-1,0,1042,\n1015,_varchar,-1,b,0,-1,0,1043,string[]\n1016,_int8,-1,b,0,-1,0,20,long[]\n1021,_float4,-1,b,0,-1,0,700,float[]\n1022,_float8,-1,b,0,-1,0,701,double[]\n1031,_numeric,-1,b,0,-1,0,1700,bigdecimal[]\n1115,_timestamp,-1,b,0,-1,0,1114,timestamp[]\n1182,_date,-1,b,0,-1,0,1082,date[]\n1183,_time,-1,b,0,-1,0,1083,time[]\n3811,_json,-1,b,0,-1,0,3811,json[]\n32824,_geometry,-1,b,0,-1,0,32816,geometry[]\n33462,_geography,-1,b,0,-1,0,33454,geography[]\n143,_xml,-1,b,0,-1,0,142,xml[]\n2287,_record,-1,b,0,-1,0,2249,\n2283,anyelement,4,p,0,-1,0,0,\n22,int2vector,-1,b,0,-1,0,0,2281,internal,8,p,0,-1,0,0,' columns oid integer, typname string, typlen short, typtype char, typbasetype integer, typtypmod integer, typrelid integer, typelem integer, teiid_name string) AS t";
        t.setSelectTransformation(transformation);
        t.setMaterialized(true);
        t.setProperty("teiid_rel:ALLOW_MATVIEW_MANAGEMENT", "true");
        return t;
    }

    private Table add_pg_database() {
        Table t = this.createView("pg_database");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("datname", "string", (ColumnSet)t);
        this.addColumn("encoding", "integer", (ColumnSet)t);
        this.addColumn("datlastsysoid", "integer", (ColumnSet)t);
        this.addColumn("datallowconn", "char", (ColumnSet)t);
        this.addColumn("datconfig", "object", (ColumnSet)t);
        this.addColumn("datacl", "object[]", (ColumnSet)t);
        this.addColumn("datdba", "integer", (ColumnSet)t);
        this.addColumn("dattablespace", "integer", (ColumnSet)t);
        String transformation = "SELECT 0 as oid, current_database() as datname, 6 as encoding, 100000 as datlastsysoid, convert('t', char) as datallowconn, null, null, 0 as datdba, 0 as dattablespace";
        t.setSelectTransformation(transformation);
        return t;
    }

    private Table add_pg_user() {
        Table t = this.createView("pg_user");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("usename", "string", (ColumnSet)t);
        this.addColumn("usesysid", "integer", (ColumnSet)t);
        this.addColumn("usecreatedb", "boolean", (ColumnSet)t);
        this.addColumn("usesuper", "boolean", (ColumnSet)t);
        String transformation = "SELECT 0 as oid, user(false) as usename, 0 as usesysid,false as usecreatedb, false as usesuper ";
        t.setSelectTransformation(transformation);
        return t;
    }

    private Table add_matpg_datatype() {
        Table t = this.createView("matpg_datatype");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("typname", "string", (ColumnSet)t);
        this.addColumn("name", "string", (ColumnSet)t);
        this.addColumn("typlen", "short", (ColumnSet)t);
        this.addColumn("typtype", "char", (ColumnSet)t);
        this.addColumn("typbasetype", "integer", (ColumnSet)t);
        this.addColumn("typtypmod", "integer", (ColumnSet)t);
        this.addPrimaryKey("matpg_datatype_names", Arrays.asList("oid", "name"), t);
        this.addIndex("matpg_datatype_ids", true, Arrays.asList("typname", "oid"), t);
        String transformation = "select pt.oid as oid, pt.typname as typname, pt.teiid_name as name, pt.typlen, pt.typtype, pt.typbasetype, pt.typtypmod from pg_catalog.pg_type pt UNION ALL select pt.oid as oid, pt.typname as typname, 'char' as name, pt.typlen, pt.typtype, pt.typbasetype, pt.typtypmod from pg_catalog.pg_type pt where typname='bpchar' UNION ALL select pt.oid as oid, pt.typname as typname, 'byte' as name, pt.typlen, pt.typtype, pt.typbasetype, pt.typtypmod from pg_catalog.pg_type pt where typname='int2' UNION ALL select pt.oid as oid, pt.typname as typname, 'biginteger' as name, pt.typlen, pt.typtype, pt.typbasetype, pt.typtypmod from pg_catalog.pg_type pt where typname='numeric' UNION ALL select pt.oid as oid, pt.typname as typname, 'varbinary' as name, pt.typlen, pt.typtype, pt.typbasetype, pt.typtypmod from pg_catalog.pg_type pt where typname='bytea' UNION ALL select pt.oid as oid, pt.typname as typname, 'byte[]' as name, pt.typlen, pt.typtype, pt.typbasetype, pt.typtypmod from pg_catalog.pg_type pt where typname='_int2' UNION ALL select pt.oid as oid, pt.typname as typname, 'biginteger[]' as name, pt.typlen, pt.typtype, pt.typbasetype, pt.typtypmod from pg_catalog.pg_type pt where typname='_numeric' UNION ALL select pt.oid as oid, pt.typname as typname, 'varbinary[]' as name, pt.typlen, pt.typtype, pt.typbasetype, pt.typtypmod from pg_catalog.pg_type pt where typname='_bytea' UNION ALL select pt.oid as oid, pt.typname as typname, 'char[]' as name, pt.typlen, pt.typtype, pt.typbasetype, pt.typtypmod from pg_catalog.pg_type pt where typname='_bpchar'";
        t.setSelectTransformation(transformation);
        t.setMaterialized(true);
        t.setProperty("teiid_rel:ALLOW_MATVIEW_MANAGEMENT", "true");
        return t;
    }

    private Table add_infoSchemaViews() {
        Table t = this.createView("information_schema.views");
        this.addColumn("table_catalog", "string", (ColumnSet)t);
        this.addColumn("table_schema", "string", (ColumnSet)t);
        this.addColumn("table_name", "string", (ColumnSet)t);
        this.addColumn("check_option", "string", (ColumnSet)t);
        this.addColumn("is_updatable", "string", (ColumnSet)t);
        t.setSelectTransformation("select vdbname, schemaName, name, 'NONE', case when SupportsUpdates then 'YES' else 'NO' end from sys.tables where NOT IsPhysical");
        return t;
    }

    private Table add_infoSchemaTables() {
        Table t = this.createView("information_schema.tables");
        this.addColumn("table_catalog", "string", (ColumnSet)t);
        this.addColumn("table_schema", "string", (ColumnSet)t);
        this.addColumn("table_name", "string", (ColumnSet)t);
        this.addColumn("table_type", "string", (ColumnSet)t);
        t.setSelectTransformation("select vdbname, schemaName, name, case when IsSystem then 'SYSTEM ' else '' end || case when IsPhysical then 'BASE TABLE' else 'VIEW' end from sys.tables");
        return t;
    }

    private Table add_infoSchemaColumns() {
        Table t = this.createView("information_schema.columns");
        this.addColumn("table_catalog", "string", (ColumnSet)t);
        this.addColumn("table_schema", "string", (ColumnSet)t);
        this.addColumn("table_name", "string", (ColumnSet)t);
        this.addColumn("column_name", "string", (ColumnSet)t);
        this.addColumn("ordinal_position", "integer", (ColumnSet)t);
        this.addColumn("column_default", "string", (ColumnSet)t);
        this.addColumn("is_nullable", "string", (ColumnSet)t);
        this.addColumn("udt_name", "string", (ColumnSet)t);
        this.addColumn("data_type", "string", (ColumnSet)t);
        this.addColumn("character_maximum_length", "integer", (ColumnSet)t);
        this.addColumn("character_octet_length", "integer", (ColumnSet)t);
        this.addColumn("numeric_precision", "integer", (ColumnSet)t);
        this.addColumn("numeric_precision_radix", "integer", (ColumnSet)t);
        this.addColumn("numeric_scale", "integer", (ColumnSet)t);
        this.addColumn("datetime_precision", "integer", (ColumnSet)t);
        this.addColumn("character_set_catalog", "string", (ColumnSet)t);
        this.addColumn("character_set_schema", "string", (ColumnSet)t);
        this.addColumn("character_set_name", "string", (ColumnSet)t);
        this.addColumn("collation_catalog", "string", (ColumnSet)t);
        this.addColumn("is_updatable", "string", (ColumnSet)t);
        t.setSelectTransformation("select vdbname, schemaName, tableName, columns.name, position, defaultValue, case when NullType = 'No Nulls' then 'NO' else 'YES' end, typname, case WHEN endswith(']', columns.DataType) then 'ARRAY' else pg_catalog.format_type( pt.oid, 0) end, case WHEN columns.DataType in ('string', 'char') THEN columns.length end, null, CASE WHEN columns.DataType in ('bigdecimal', 'biginteger') then columns.precision WHEN columns.DataType = 'float' then 24 WHEN columns.DataType = 'double' then 53 WHEN columns.DataType in ('byte', 'short', 'integer', 'long') then pt.typlen * 8 end, CASE WHEN columns.DataType in ('bigdecimal', 'biginteger', 'float', 'double', 'byte', 'short', 'integer', 'long') then 2 end,  CASE WHEN columns.DataType in ('bigdecimal', 'biginteger') then columns.scale WHEN columns.DataType in ('byte', 'short', 'integer', 'long') then 0 end, CASE WHEN columns.DataType = 'date' then 0 WHEN columns.DataType = 'time' then 3 WHEN columns.DataType = 'timestamp' then 9 end, null, null, null, null, case when SupportsUpdates then 'YES' else 'NO' end  from sys.columns left outer join pg_catalog.matpg_datatype pt ON columns.DataType = pt.Name");
        return t;
    }

    private Table add_infoSchemaReferentialConstraints() {
        Table t = this.createView("information_schema.referential_constraints");
        this.addColumn("constraint_catalog", "string", (ColumnSet)t);
        this.addColumn("constraint_schema", "string", (ColumnSet)t);
        this.addColumn("constraint_name", "string", (ColumnSet)t);
        this.addColumn("unique_constraint_catalog", "string", (ColumnSet)t);
        this.addColumn("unique_constraint_schema", "string", (ColumnSet)t);
        this.addColumn("unique_constraint_name", "string", (ColumnSet)t);
        this.addColumn("match_option", "string", (ColumnSet)t);
        this.addColumn("update_rule", "string", (ColumnSet)t);
        this.addColumn("delete_rule", "string", (ColumnSet)t);
        t.setSelectTransformation("select PKTABLE_CAT, PKTABLE_SCHEM, PK_NAME, FKTABLE_CAT, FKTABLE_SCHEM, FK_NAME, 'NONE', 'NO ACTION', 'NO ACTION' FROM SYS.ReferenceKeyColumns group by PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, FK_NAME, PK_NAME");
        return t;
    }

    private Table add_infoSchemaKeyColumnUsage() {
        Table t = this.createView("information_schema.key_column_usage");
        this.addColumn("constraint_catalog", "string", (ColumnSet)t);
        this.addColumn("constraint_schema", "string", (ColumnSet)t);
        this.addColumn("constraint_name", "string", (ColumnSet)t);
        this.addColumn("table_catalog", "string", (ColumnSet)t);
        this.addColumn("table_schema", "string", (ColumnSet)t);
        this.addColumn("table_name", "string", (ColumnSet)t);
        this.addColumn("column_name", "string", (ColumnSet)t);
        this.addColumn("ordinal_position", "integer", (ColumnSet)t);
        this.addColumn("position_in_unique_constraint", "integer", (ColumnSet)t);
        t.setSelectTransformation("select VDBName, SchemaName, KeyName, VDBName, SchemaName, TableName, Name, KeyColumns.Position, case when RefKeyUID is not null then KeyColumns.Position end FROM SYS.KeyColumns");
        return t;
    }

    private Table add_infoSchemaTableConstraints() {
        Table t = this.createView("information_schema.table_constraints");
        this.addColumn("constraint_catalog", "string", (ColumnSet)t);
        this.addColumn("constraint_schema", "string", (ColumnSet)t);
        this.addColumn("constraint_name", "string", (ColumnSet)t);
        this.addColumn("table_catalog", "string", (ColumnSet)t);
        this.addColumn("table_schema", "string", (ColumnSet)t);
        this.addColumn("table_name", "string", (ColumnSet)t);
        this.addColumn("constraint_type", "string", (ColumnSet)t);
        this.addColumn("is_deferrable", "string", (ColumnSet)t);
        this.addColumn("initially_deferred", "string", (ColumnSet)t);
        t.setSelectTransformation("select VDBName, SchemaName, Name, VDBName, SchemaName, TableName, upper(Keys.Type || case when Keys.Type in ('Primary', 'Foreign') then ' Key' else '' end), 'NO', 'NO' FROM SYS.Keys where Keys.Type in ('Primary', 'Foreign', 'Unique')");
        return t;
    }

    private FunctionMethod addFunction(String javaFunction, String name) {
        Method[] methods;
        for (Method method : methods = FunctionMethods.class.getMethods()) {
            if (!method.getName().equals(javaFunction)) continue;
            FunctionMethod func = this.addFunction(name, method);
            func.setCategory("pg");
            func.setDescription(name);
            return func;
        }
        throw new AssertionError((Object)"Could not find function");
    }

    public static class FunctionMethods {
        public static ClobType encode(BlobType value, String encoding) throws SQLException, IOException {
            return org.teiid.query.function.FunctionMethods.toChars((BlobType)value, (String)encoding);
        }

        public static String postgisLibVersion() {
            return PgCatalogMetadataStore.POSTGIS_LIB_VERSION;
        }

        public static String postgisVersion() {
            return "2.0.0";
        }

        public static String postgisGeosVersion() {
            return null;
        }

        public static String postgisProjVersion() {
            return "Rel. 4.8.0";
        }

        public static Boolean hasPerm(Integer oid, String permission) {
            return true;
        }

        public static String getExpr2(String text, Integer oid) {
            return text;
        }

        public static String getExpr3(String text, Integer oid, Boolean prettyPrint) {
            return text;
        }

        public static Object asPGVector(Object obj) {
            if (obj instanceof ArrayImpl) {
                ((ArrayImpl)obj).setZeroBased(true);
            }
            return obj;
        }

        public static Integer getOid(CommandContext cc, String uid) {
            VDBMetaData metadata = (VDBMetaData)cc.getVdb();
            TransformationMetadata tm = (TransformationMetadata)metadata.getAttachment(TransformationMetadata.class);
            return tm.getMetadataStore().getOid(uid);
        }

        public static String pg_client_encoding(CommandContext cc) {
            SessionMetadata session = (SessionMetadata)cc.getSession();
            ODBCServerRemoteImpl server = (ODBCServerRemoteImpl)session.getAttachment(ODBCServerRemoteImpl.class);
            String encoding = null;
            if (server != null) {
                encoding = server.getEncoding();
            }
            if (encoding == null) {
                return "UTF8";
            }
            return encoding;
        }

        public static Integer regClass(CommandContext cc, String name) throws TeiidComponentException, QueryResolverException, ParseException {
            VDBMetaData metadata = (VDBMetaData)cc.getVdb();
            TransformationMetadata tm = (TransformationMetadata)metadata.getAttachment(TransformationMetadata.class);
            GroupSymbol symbol = new GroupSymbol(SQLParserUtil.normalizeId((String)name));
            ResolverUtil.resolveGroup((GroupSymbol)symbol, (QueryMetadataInterface)tm);
            return tm.getMetadataStore().getOid(((Table)symbol.getMetadataID()).getUUID());
        }

        public static String objDescription(CommandContext cc, int oid) {
            return null;
        }

        public static String objDescription2(CommandContext cc, int oid, String type) {
            return null;
        }

        public static String getUserById(int user) {
            return "pgadmin";
        }

        public static boolean hasSchemaPrivilege(CommandContext cc, String name, String privilege) {
            return "usage".equalsIgnoreCase(privilege);
        }

        public static boolean hasTablePrivilege(CommandContext cc, String name, String privilege) {
            return true;
        }

        public static String currentSchema(CommandContext cc) {
            return "SYS";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String formatType(CommandContext cc, Integer oid, Integer typmod) throws SQLException {
            if (oid == null) {
                return null;
            }
            try (TeiidConnection c = cc.getConnection();){
                PreparedStatement ps = c.prepareStatement("select typname from pg_catalog.pg_type where oid = ?");
                ps.setInt(1, oid);
                ps.execute();
                ResultSet rs = ps.getResultSet();
                if (rs.next()) {
                    String name = rs.getString(1);
                    boolean isArray = name.startsWith("_");
                    if (isArray) {
                        name = name.substring(1);
                    }
                    switch (name) {
                        case "bool": {
                            name = "boolean";
                            break;
                        }
                        case "varchar": {
                            name = "character varying";
                            break;
                        }
                        case "int2": {
                            name = "smallint";
                            break;
                        }
                        case "int4": {
                            name = "integer";
                            break;
                        }
                        case "int8": {
                            name = "bigint";
                            break;
                        }
                        case "float4": {
                            name = "real";
                            break;
                        }
                        case "float8": {
                            name = "double precision";
                            break;
                        }
                        case "bpchar": {
                            name = "character";
                        }
                    }
                    if (typmod != null && typmod > 4) {
                        if (name.equals("numeric")) {
                            name = name + "(" + (typmod - 4 >> 16) + "," + (typmod - 4 & 0xFFFF) + ")";
                        } else if (name.equals("character") || name.equals("varchar")) {
                            name = name + "(" + (typmod - 4) + ")";
                        }
                    }
                    if (isArray) {
                        name = name + "[]";
                    }
                    String string = name;
                    return string;
                }
                String string = "???";
                return string;
            }
        }

        public static String colDescription(CommandContext cc, int oid, int column_number) {
            return null;
        }

        public static boolean pgHasRole(CommandContext cc, int userOid, String privilege) {
            return true;
        }

        public static BlobType asBinary2(GeometryType geom, String encoding) throws FunctionExecutionException {
            return GeometryFunctionMethods.asBlob((AbstractGeospatialType)geom, (String)encoding);
        }

        public static BlobType asBinary3(GeographyType geog, String encoding) throws FunctionExecutionException {
            return GeometryFunctionMethods.asBlob((AbstractGeospatialType)geog, (String)encoding);
        }

        public static boolean pg_table_is_visible(int oid) throws FunctionExecutionException {
            return true;
        }

        /*
         * Exception decompiling
         */
        public static String pg_get_constraintdef(CommandContext cc, int oid, boolean pretty) throws SQLException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public static boolean pg_type_is_visible(int oid) throws FunctionExecutionException {
            return true;
        }

        public static String version() {
            return POSTGRESQL_VERSION;
        }

        public static String pg_encoding_to_char(int code) {
            if (code == 6) {
                return "UTF8";
            }
            throw new AssertionError((Object)"Unknown encoding");
        }

        public static String[] current_schemas(CommandContext cc, boolean include_implicit) {
            if (include_implicit) {
                VDBMetaData metadata = (VDBMetaData)cc.getVdb();
                TransformationMetadata tm = (TransformationMetadata)metadata.getAttachment(TransformationMetadata.class);
                List schemas = tm.getMetadataStore().getSchemaList();
                String[] results = new String[schemas.size()];
                for (int i = 0; i < results.length; ++i) {
                    results[i] = ((Schema)schemas.get(i)).getName();
                }
                return results;
            }
            List models = cc.getVdb().getModels();
            String[] results = new String[models.size()];
            for (int i = 0; i < results.length; ++i) {
                results[i] = ((Model)models.get(i)).getName();
            }
            return results;
        }

        /*
         * Exception decompiling
         */
        public static String pg_get_indexdef(CommandContext cc, int index_oid, short column_no, boolean pretty_bool) throws TeiidSQLException, SQLException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public static String array_to_string(CommandContext cc, Object[] array, String delim) {
            return StringUtil.join((Collection)Arrays.asList(array).stream().map(o -> {
                try {
                    return (String)DataTypeManager.transformValue((Object)o, (Class)DataTypeManager.DefaultDataClasses.STRING);
                }
                catch (TransformationException e) {
                    throw new TeiidRuntimeException((Throwable)e);
                }
            }).collect(Collectors.toList()), (String)delim);
        }
    }
}

