/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.service.jcache;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.UUID;
import java.util.stream.Stream;
import javax.cache.annotation.CacheInvocationParameter;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CacheKeyInvocationContext;
import javax.cache.annotation.GeneratedCacheKey;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class FrontCacheKeyGenerator
implements CacheKeyGenerator {
    private static final Logger log = LoggerFactory.getLogger(FrontCacheKeyGenerator.class);
    @Inject
    @Context
    private Request request;
    @Inject
    @Context
    private UriInfo uriInfo;
    @Inject
    @Context
    private HttpHeaders headers;

    public GeneratedCacheKey generateCacheKey(CacheKeyInvocationContext<? extends Annotation> cacheKeyInvocationContext) {
        return new GeneratedCacheKeyImpl(Stream.concat(Stream.of(cacheKeyInvocationContext.getKeyParameters()).map(CacheInvocationParameter::getValue), this.getContextualKeys()).toArray(Object[]::new));
    }

    private Stream<Object> getContextualKeys() {
        try {
            return Stream.of(this.uriInfo.getPath(), this.uriInfo.getQueryParameters(), this.headers.getLanguage(), this.headers.getHeaderString("Accept"), this.headers.getHeaderString("Accept-Encoding"));
        }
        catch (Exception e) {
            log.debug("[getContextualKeys] context not applicable: {}", (Object)e.getMessage());
            return Stream.of(UUID.randomUUID());
        }
    }

    private static class GeneratedCacheKeyImpl
    implements GeneratedCacheKey {
        private final Object[] params;
        private final int hash;

        private GeneratedCacheKeyImpl(Object[] parameters) {
            this.params = parameters;
            this.hash = Arrays.deepHashCode(parameters);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GeneratedCacheKeyImpl that = (GeneratedCacheKeyImpl)GeneratedCacheKeyImpl.class.cast(o);
            return Arrays.deepEquals(this.params, that.params);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

