/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.server;

import java.nio.charset.Charset;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.textline.LineDelimiter;
import org.apache.mina.filter.codec.textline.TextLineEncoder;
import org.subethamail.smtp.server.SMTPCodecDecoder;

public class SMTPCodecFactory
implements ProtocolCodecFactory {
    private final TextLineEncoder encoder;
    private final SMTPCodecDecoder decoder;

    public SMTPCodecFactory() {
        this(Charset.defaultCharset(), 0x400000);
    }

    public SMTPCodecFactory(Charset charset, int thresholdBytes) {
        this.encoder = new TextLineEncoder(charset, new LineDelimiter("\r\n"));
        this.decoder = new SMTPCodecDecoder(charset, thresholdBytes);
    }

    public ProtocolEncoder getEncoder() {
        return this.encoder;
    }

    public ProtocolDecoder getDecoder() {
        return this.decoder;
    }

    public int getEncoderMaxLineLength() {
        return this.encoder.getMaxLineLength();
    }

    public void setEncoderMaxLineLength(int maxLineLength) {
        this.encoder.setMaxLineLength(maxLineLength);
    }

    public int getDecoderMaxLineLength() {
        return this.decoder.getMaxLineLength();
    }

    public void setDecoderMaxLineLength(int maxLineLength) {
        this.decoder.setMaxLineLength(maxLineLength);
    }
}

