/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.xd.dirt.web.controller.support.AuthenticationRequest;

@Controller
public class LoginController {
    private final AuthenticationManager authenticationManager;
    @Autowired
    ApplicationContext applicationContext;

    @Autowired
    public LoginController(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    @RequestMapping(value={"/authenticate"}, method={RequestMethod.POST})
    @ResponseBody
    public String authorize(@RequestBody AuthenticationRequest authenticationRequest, HttpServletRequest request) {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)authenticationRequest.getUsername(), (Object)authenticationRequest.getPassword());
        Authentication authentication = this.authenticationManager.authenticate((Authentication)token);
        SecurityContextHolder.getContext().setAuthentication(authentication);
        HttpSession session = request.getSession(true);
        session.setAttribute("SPRING_SECURITY_CONTEXT", (Object)SecurityContextHolder.getContext());
        return session.getId();
    }

    @RequestMapping(value={"/admin-ui/"})
    String index() {
        return "forward:/admin-ui/index.html";
    }

    @RequestMapping(value={"/admin-ui"})
    String indexWithoutTrailingSlash() {
        return "redirect:/admin-ui/";
    }
}

