/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.tuple;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.core.convert.converter.Converter;

public class StringToDateConverter
implements Converter<String, Date> {
    private static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    private DateFormat dateFormat;

    public StringToDateConverter() {
        this.dateFormat = new SimpleDateFormat(DEFAULT_DATE_PATTERN);
        this.dateFormat.setLenient(false);
    }

    public StringToDateConverter(String pattern) {
        this.dateFormat = new SimpleDateFormat(pattern);
        this.dateFormat.setLenient(false);
    }

    public StringToDateConverter(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public Date convert(String source) {
        try {
            return this.dateFormat.parse(source);
        }
        catch (ParseException e) {
            String pattern = this.dateFormat instanceof SimpleDateFormat ? ((SimpleDateFormat)this.dateFormat).toPattern() : this.dateFormat.toString();
            throw new IllegalArgumentException(e.getMessage() + ", format: [" + pattern + "]");
        }
    }
}

