/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.module.support;

import java.io.IOException;
import java.util.ArrayList;
import org.springframework.boot.loader.archive.Archive;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.xd.module.support.NestedArchiveResource;

public class ArchiveResourceLoader
extends DefaultResourceLoader
implements ResourcePatternResolver {
    private final Archive archive;
    private final PathMatcher pathMatcher = new AntPathMatcher();

    public ArchiveResourceLoader(Archive archive) {
        this.archive = archive;
    }

    public Resource[] getResources(final String locationPattern) throws IOException {
        final ArrayList paths = new ArrayList();
        this.archive.getNestedArchives(new Archive.EntryFilter(){

            public boolean matches(Archive.Entry entry) {
                String path = "/" + entry.getName().toString();
                boolean match = ArchiveResourceLoader.this.pathMatcher.match(locationPattern, path);
                if (match) {
                    paths.add(path);
                }
                return match;
            }
        });
        Resource[] result = new Resource[paths.size()];
        int i = 0;
        for (String path : paths) {
            result[i++] = new NestedArchiveResource(this.archive, path);
        }
        return result;
    }

    protected Resource getResourceByPath(String path) {
        if (!path.startsWith("/")) {
            return super.getResourceByPath(path);
        }
        return new NestedArchiveResource(this.archive, path);
    }
}

