/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.module.options;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.MapBindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.xd.module.options.ModuleOption;
import org.springframework.xd.module.options.ModuleOptions;
import org.springframework.xd.module.options.ModuleOptionsMetadata;

public class FlattenedCompositeModuleOptionsMetadata
implements ModuleOptionsMetadata {
    private static final String INPUT_TYPE = "inputType";
    private static final Logger logger = LoggerFactory.getLogger(FlattenedCompositeModuleOptionsMetadata.class);
    private Map<String, ModuleOption> options = new LinkedHashMap<String, ModuleOption>();
    private Map<ModuleOptionsMetadata, Set<String>> momToSupportedOptions = new LinkedHashMap<ModuleOptionsMetadata, Set<String>>();

    public FlattenedCompositeModuleOptionsMetadata(List<? extends ModuleOptionsMetadata> delegates) {
        ModuleOption inputType = null;
        for (ModuleOptionsMetadata moduleOptionsMetadata : delegates) {
            HashSet<String> optionNames = new HashSet<String>();
            this.momToSupportedOptions.put(moduleOptionsMetadata, optionNames);
            for (ModuleOption option : moduleOptionsMetadata) {
                ModuleOption alreadyThere = this.options.get(option.getName());
                if (alreadyThere != null && !alreadyThere.equals(option)) {
                    if (option.getName().equals(INPUT_TYPE)) {
                        inputType = alreadyThere;
                    } else {
                        this.reportOptionCollision(delegates, option.getName());
                    }
                }
                this.options.put(option.getName(), option.getName().equals(INPUT_TYPE) && inputType != null ? inputType : option);
                optionNames.add(option.getName());
            }
        }
    }

    private void reportOptionCollision(List<? extends ModuleOptionsMetadata> delegates, String optionName) {
        ArrayList<ModuleOptionsMetadata> offenders = new ArrayList<ModuleOptionsMetadata>();
        for (ModuleOptionsMetadata moduleOptionsMetadata : delegates) {
            for (ModuleOption option : moduleOptionsMetadata) {
                if (!option.getName().equals(optionName)) continue;
                offenders.add(moduleOptionsMetadata);
            }
        }
        throw new IllegalArgumentException(String.format("Module option named '%s' is present in several delegates, with different attributes: %s", optionName, offenders));
    }

    @Override
    public Iterator<ModuleOption> iterator() {
        return this.options.values().iterator();
    }

    @Override
    public ModuleOptions interpolate(Map<String, String> raw) throws BindException {
        HashMap<ModuleOptionsMetadata, Map<String, String>> distributed = new HashMap<ModuleOptionsMetadata, Map<String, String>>(){

            @Override
            public Map<String, String> get(Object key) {
                HashMap result = (HashMap)super.get(key);
                if (result == null) {
                    result = new HashMap();
                    this.put((ModuleOptionsMetadata)key, result);
                }
                return result;
            }
        };
        HashMap<String, String> copy = new HashMap<String, String>(raw);
        block0: for (String key : raw.keySet()) {
            for (ModuleOptionsMetadata mom : this.momToSupportedOptions.keySet()) {
                Set<String> optionNames = this.momToSupportedOptions.get(mom);
                if (!optionNames.contains(key)) continue;
                ((Map)distributed.get(mom)).put(key, copy.remove(key));
                continue block0;
            }
        }
        if (copy.size() > 0) {
            MapBindingResult bindingResult = new MapBindingResult(new HashMap(), "flattened");
            for (String pty : copy.keySet()) {
                bindingResult.addError((ObjectError)new FieldError("flattened", pty, String.format("option named '%s' is not supported", pty)));
            }
            throw new BindException((BindingResult)bindingResult);
        }
        final HashMap<String, ModuleOptions> nameToOptions = new HashMap<String, ModuleOptions>();
        for (ModuleOptionsMetadata mom : this.momToSupportedOptions.keySet()) {
            Map rawValuesSubset = (Map)distributed.get(mom);
            ModuleOptions mo = mom.interpolate(rawValuesSubset);
            EnumerablePropertySource<?> propertySource = mo.asPropertySource();
            for (String optionName : propertySource.getPropertyNames()) {
                if (optionName.equals(INPUT_TYPE)) {
                    if (propertySource.getProperty(optionName) == null) continue;
                    nameToOptions.put(optionName, mo);
                    continue;
                }
                nameToOptions.put(optionName, mo);
            }
        }
        final HashSet uniqueModuleOptions = new HashSet(nameToOptions.values());
        return new ModuleOptions(){

            public EnumerablePropertySource<FlattenedCompositeModuleOptionsMetadata> asPropertySource() {
                String psName = String.format("flattened-%d", System.identityHashCode(FlattenedCompositeModuleOptionsMetadata.this));
                return new EnumerablePropertySource<FlattenedCompositeModuleOptionsMetadata>(psName, FlattenedCompositeModuleOptionsMetadata.this){

                    public String[] getPropertyNames() {
                        Object[] result = nameToOptions.keySet().toArray(new String[nameToOptions.keySet().size()]);
                        logger.debug(String.format("returning propertyNames: %s", StringUtils.arrayToCommaDelimitedString((Object[])result)));
                        return result;
                    }

                    public Object getProperty(String name) {
                        ModuleOptions moduleOptions = (ModuleOptions)nameToOptions.get(name);
                        return moduleOptions == null ? null : moduleOptions.asPropertySource().getProperty(name);
                    }
                };
            }

            @Override
            public String[] profilesToActivate() {
                ArrayList<String> result = new ArrayList<String>();
                for (ModuleOptions delegate : uniqueModuleOptions) {
                    result.addAll(Arrays.asList(delegate.profilesToActivate()));
                }
                return result.toArray(new String[result.size()]);
            }

            @Override
            public void validate() {
                for (ModuleOptions delegate : uniqueModuleOptions) {
                    delegate.validate();
                }
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        for (ModuleOptionsMetadata sub : this.momToSupportedOptions.keySet()) {
            sb.append("\n").append(this.momToSupportedOptions.get(sub)).append(" => ").append(sub);
        }
        return sb.toString();
    }
}

