/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.module.options.mixins;

import javax.validation.constraints.AssertTrue;
import org.springframework.util.StringUtils;
import org.springframework.xd.module.options.spi.ModuleOption;

public class ScriptMixin {
    private String script = null;
    private String propertiesLocation;
    private String variables;
    private long refreshDelay = 60000L;

    public String getVariables() {
        return this.variables;
    }

    public String getScript() {
        return this.script;
    }

    public String getPropertiesLocation() {
        return this.propertiesLocation;
    }

    @ModuleOption(value="reference to a script used to process messages")
    public void setScript(String script) {
        this.script = script;
    }

    @ModuleOption(value="the path of a properties file containing custom script variable bindings")
    public void setPropertiesLocation(String propertiesLocation) {
        this.propertiesLocation = propertiesLocation;
    }

    @ModuleOption(value="variable bindings as a comma delimited string of name-value pairs, e.g., 'foo=bar,baz=car'")
    public void setVariables(String variables) {
        this.variables = variables;
    }

    public long getRefreshDelay() {
        return this.refreshDelay;
    }

    @ModuleOption(value="how often to check (in milliseconds) whether the script has changed; -1 for never")
    public void setRefreshDelay(long refreshDelay) {
        this.refreshDelay = refreshDelay;
    }

    @AssertTrue(message="'script' cannot be null or empty")
    public boolean isValid() {
        return StringUtils.hasText((String)this.script);
    }
}

