/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.module.options.mixins;

import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import org.springframework.xd.module.options.spi.ModuleOption;

public class PeriodicTriggerMixin {
    private int initialDelay = 0;
    private String timeUnit = "SECONDS";

    @Min(value=0L)
    public int getInitialDelay() {
        return this.initialDelay;
    }

    @ModuleOption(value="an initial delay when using a fixed delay trigger, expressed in TimeUnits (seconds by default)")
    public void setInitialDelay(int initialDelay) {
        this.initialDelay = initialDelay;
    }

    @Pattern(regexp="(?i)(NANOSECONDS|MICROSECONDS|MILLISECONDS|SECONDS|MINUTES|HOURS|DAYS)", message="timeUnit must be one of NANOSECONDS, MICROSECONDS, MILLISECONDS, SECONDS, MINUTES, HOURS, DAYS (case-insensitive)")
    public String getTimeUnit() {
        return this.timeUnit;
    }

    @ModuleOption(value="the time unit for the fixed and initial delays")
    public void setTimeUnit(String timeUnit) {
        this.timeUnit = timeUnit.toUpperCase();
    }
}

