/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.module.options.mixins;

import javax.validation.constraints.NotNull;
import org.springframework.xd.module.options.mixins.MongoDbConnectionMixin;
import org.springframework.xd.module.options.spi.Mixin;
import org.springframework.xd.module.options.spi.ModuleOption;

public abstract class IntoMongoDbOptionMixin {
    private String collectionName;
    private WriteConcern writeConcern = WriteConcern.SAFE;

    protected IntoMongoDbOptionMixin(String collectionName) {
        this.collectionName = collectionName;
    }

    @ModuleOption(value="the MongoDB collection to store")
    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    @ModuleOption(value="the default MongoDB write concern to use")
    public void setWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    @NotNull
    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public static enum WriteConcern {
        NONE,
        NORMAL,
        SAFE,
        FSYNC_SAFE,
        REPLICAS_SAFE,
        JOURNAL_SAFE,
        MAJORITY;

    }

    @Mixin(value={MongoDbConnectionMixin.class})
    public static class Stream
    extends IntoMongoDbOptionMixin {
        public Stream() {
            super("${xd.stream.name}");
        }
    }

    @Mixin(value={MongoDbConnectionMixin.class})
    public static class Job
    extends IntoMongoDbOptionMixin {
        public Job() {
            super("${xd.job.name}");
        }
    }
}

