/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.batch.hsqldb.server;

import com.sun.management.UnixOperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.net.SocketException;
import java.util.Properties;
import org.hsqldb.Server;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.server.ServerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class HSQLServerBean
implements InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(HSQLServerBean.class);
    private Properties serverProperties;
    private Server server;

    public Properties getServerProperties() {
        return this.serverProperties;
    }

    public void setServerProperties(Properties serverProperties) {
        this.serverProperties = serverProperties;
    }

    public void afterPropertiesSet() throws Exception {
        HsqlProperties configProps = this.serverProperties != null ? new HsqlProperties(this.serverProperties) : new HsqlProperties();
        ServerConfiguration.translateDefaultDatabaseProperty((HsqlProperties)configProps);
        this.server = new Server();
        this.server.setLogWriter(null);
        this.server.setRestartOnShutdown(false);
        this.server.setNoSystemExit(true);
        this.server.setProperties(configProps);
        logger.debug("HSQL Database path: " + this.server.getDatabasePath(0, true));
        this.startServer();
    }

    private void startServer() throws Exception {
        boolean started;
        logger.info("Starting HSQL Server database '" + this.server.getDatabaseName(0, true) + "' listening on port: " + this.server.getPort());
        int tries = 0;
        Throwable t = null;
        do {
            this.server.start();
            boolean bl = started = this.server.getState() == 1;
            if (!started) {
                Thread.sleep(1000L);
                boolean bl2 = started = this.server.getState() == 1;
            }
            if (started) continue;
            t = this.server.getServerError();
            if (!(t instanceof SocketException) || !"Invalid argument".equals(t.getMessage())) break;
            long fileCount = this.getOpenFileDescriptorCount();
            logger.debug(String.format("Caught SocketException (likely due to excessive file descriptors open; current count: %d)", fileCount), t);
            long timeout = System.currentTimeMillis() + 5000L;
            while (System.currentTimeMillis() < timeout && fileCount > 1024L) {
                Thread.sleep(500L);
                fileCount = this.getOpenFileDescriptorCount();
            }
            logger.debug(String.format("Open files: %d", this.getOpenFileDescriptorCount()));
        } while (!started && ++tries < 5);
        if (!started) {
            String msg = String.format("HSQLDB could not be started on %s:%d, state: %s", this.server.getAddress(), this.server.getPort(), this.server.getStateDescriptor());
            if (t == null) {
                throw new IllegalStateException(msg);
            }
            throw new IllegalStateException(msg, t);
        }
        logger.info("Started HSQL Server");
    }

    private long getOpenFileDescriptorCount() {
        OperatingSystemMXBean osStats = ManagementFactory.getOperatingSystemMXBean();
        return osStats instanceof UnixOperatingSystemMXBean ? ((UnixOperatingSystemMXBean)osStats).getOpenFileDescriptorCount() : -1L;
    }

    public void destroy() {
        this.shutdownServer();
    }

    private void shutdownServer() {
        logger.info("HSQL Server Shutdown sequence initiated");
        if (this.server != null) {
            this.server.signalCloseAllServerConnections();
            this.server.stop();
            this.server.shutdown();
            int attempts = 0;
            while (this.server.getState() != 16 && attempts++ < 50) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            if (this.server.getState() == 16) {
                logger.info("HSQL Server Shutdown completed.");
            } else {
                logger.warn("HSQL Server Shutdown timed out or was interrupted. Server State: " + this.server.getState());
            }
            this.server = null;
        }
    }
}

