/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.batch;

import javax.sql.DataSource;
import org.springframework.batch.support.DatabaseType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.batch.BatchDatabaseInitializer;
import org.springframework.core.io.ResourceLoader;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.jdbc.support.MetaDataAccessException;

public class XdBatchDatabaseInitializer
extends BatchDatabaseInitializer {
    private static final String REGISTRY_SCHEMA_LOCATION = "classpath:org/springframework/xd/batch/schema/registry-schema-@@platform@@.sql";
    @Autowired
    private DataSource dataSource;
    @Autowired
    private ResourceLoader resourceLoader;
    @Value(value="${spring.batch.initializer.enabled:true}")
    private boolean enabled = true;

    protected void initialize() throws DataAccessException {
        super.initialize();
        if (this.enabled) {
            try {
                String platform = DatabaseType.fromMetaData((DataSource)this.dataSource).toString().toLowerCase();
                if ("hsql".equals(platform)) {
                    platform = "hsqldb";
                }
                if ("postgres".equals(platform)) {
                    platform = "postgresql";
                }
                if ("oracle".equals(platform)) {
                    platform = "oracle10g";
                }
                ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
                populator.addScript(this.resourceLoader.getResource(REGISTRY_SCHEMA_LOCATION.replace("@@platform@@", platform)));
                populator.setContinueOnError(true);
                DatabasePopulatorUtils.execute((DatabasePopulator)populator, (DataSource)this.dataSource);
            }
            catch (MetaDataAccessException e) {
                throw new DataRetrievalFailureException("Could not retrieve ", (Throwable)e);
            }
        }
    }
}

