/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.analytics.metrics.redis;

import java.util.Collections;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryOperations;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.StringUtils;
import org.springframework.xd.analytics.metrics.core.MetricUtils;
import org.springframework.xd.analytics.metrics.core.RichGauge;
import org.springframework.xd.analytics.metrics.core.RichGaugeRepository;
import org.springframework.xd.analytics.metrics.redis.AbstractRedisMetricRepository;

public class RedisRichGaugeRepository
extends AbstractRedisMetricRepository<RichGauge, String>
implements RichGaugeRepository {
    private static final String ZERO = RedisRichGaugeRepository.serialize(new RichGauge("ZERO"));
    private RetryTemplate retryTemplate = new RetryTemplate();

    public RedisRichGaugeRepository(RedisConnectionFactory connectionFactory, RetryOperations retryOperations) {
        super(connectionFactory, "richgauges.", String.class, retryOperations);
        this.retryTemplate.setRetryPolicy((RetryPolicy)new SimpleRetryPolicy(3, Collections.singletonMap(OptimisticLockingFailureException.class, true)));
        ExponentialBackOffPolicy backOffPolicy = new ExponentialBackOffPolicy();
        backOffPolicy.setInitialInterval(50L);
        backOffPolicy.setMaxInterval(1000L);
        backOffPolicy.setMultiplier(2.0);
        this.retryTemplate.setBackOffPolicy((BackOffPolicy)backOffPolicy);
    }

    private static String serialize(RichGauge g) {
        StringBuilder sb = new StringBuilder();
        sb.append(Double.toString(g.getValue())).append(" ");
        sb.append(Double.toString(g.getAlpha())).append(" ");
        sb.append(Double.toString(g.getAverage())).append(" ");
        sb.append(Double.toString(g.getMax())).append(" ");
        sb.append(Double.toString(g.getMin())).append(" ");
        sb.append(Long.toString(g.getCount()));
        return sb.toString();
    }

    @Override
    RichGauge create(String name, String value) {
        String[] parts = StringUtils.delimitedListToStringArray((String)value, (String)" ");
        return new RichGauge(name, Double.valueOf(parts[0]), Double.valueOf(parts[1]), Double.valueOf(parts[2]), Double.valueOf(parts[3]), Double.valueOf(parts[4]), Long.valueOf(parts[5]));
    }

    @Override
    String defaultValue() {
        return ZERO;
    }

    @Override
    String value(RichGauge metric) {
        return RedisRichGaugeRepository.serialize(metric);
    }

    @Override
    public void recordValue(final String name, final double value, final double alpha) {
        final String key = this.getMetricKey(name);
        this.retryTemplate.execute((RetryCallback)new RetryCallback<Void, RuntimeException>(){

            public Void doWithRetry(RetryContext context) {
                return (Void)RedisRichGaugeRepository.this.getRedisOperations().execute((SessionCallback)new SessionCallback<Void>(){

                    public <K, V> Void execute(RedisOperations<K, V> operations) throws DataAccessException {
                        operations.watch((Object)key);
                        RichGauge g = (RichGauge)RedisRichGaugeRepository.this.findOne(name);
                        if (g == null) {
                            g = new RichGauge(name);
                        }
                        operations.multi();
                        MetricUtils.setRichGaugeValue(g, value, alpha);
                        operations.opsForValue().set((Object)key, (Object)RedisRichGaugeRepository.serialize(g));
                        List result = operations.exec();
                        if (result == null) {
                            throw new OptimisticLockingFailureException(String.format("Failed to set value of rich-gauge '%s' to %f", name, value));
                        }
                        return null;
                    }
                });
            }
        });
    }

    public void setRetryTemplate(RetryTemplate retryTemplate) {
        this.retryTemplate = retryTemplate;
    }

    @Override
    public void reset(String name) {
        this.getValueOperations().set((Object)this.getMetricKey(name), (Object)ZERO);
    }
}

