/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.analytics.metrics.redis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.Months;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.Years;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.serializer.GenericToStringSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.retry.RetryOperations;
import org.springframework.util.Assert;
import org.springframework.xd.analytics.metrics.core.AggregateCount;
import org.springframework.xd.analytics.metrics.core.AggregateCountResolution;
import org.springframework.xd.analytics.metrics.core.AggregateCounterRepository;
import org.springframework.xd.analytics.metrics.core.MetricUtils;
import org.springframework.xd.analytics.metrics.redis.AggregateKeyGenerator;
import org.springframework.xd.analytics.metrics.redis.RedisCounterRepository;
import org.springframework.xd.analytics.metrics.redis.RedisRetryTemplate;

@Qualifier(value="aggregate")
public class RedisAggregateCounterRepository
extends RedisCounterRepository
implements AggregateCounterRepository {
    protected HashOperations<String, String, Long> hashOperations;
    protected SetOperations<String, String> setOperations;

    public RedisAggregateCounterRepository(RedisConnectionFactory redisConnectionFactory, RetryOperations retryOperations) {
        super("aggregatecounters", redisConnectionFactory, retryOperations);
        RedisRetryTemplate redisTemplate = new RedisRetryTemplate();
        redisTemplate.setConnectionFactory(redisConnectionFactory);
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setValueSerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setHashValueSerializer((RedisSerializer)new GenericToStringSerializer(Long.class));
        redisTemplate.setRetryOperations(retryOperations);
        redisTemplate.afterPropertiesSet();
        this.hashOperations = redisTemplate.opsForHash();
        this.setOperations = redisTemplate.opsForSet();
    }

    @Override
    public long increment(String name) {
        return this.increment(name, 1L, new DateTime());
    }

    @Override
    public long increment(String name, long amount) {
        return this.increment(name, amount, new DateTime());
    }

    @Override
    public long increment(String name, long amount, DateTime dateTime) {
        AggregateKeyGenerator akg = new AggregateKeyGenerator(this.getPrefix(), name, (ReadableDateTime)dateTime);
        String bookkeepingKey = this.bookkeepingKeyFor(name);
        this.doIncrementHash(akg.getYearsKey(), akg.getYear(), amount, bookkeepingKey);
        this.doIncrementHash(akg.getYearKey(), akg.getMonth(), amount, bookkeepingKey);
        this.doIncrementHash(akg.getMonthKey(), akg.getDay(), amount, bookkeepingKey);
        this.doIncrementHash(akg.getDayKey(), akg.getHour(), amount, bookkeepingKey);
        this.doIncrementHash(akg.getHourKey(), akg.getMinute(), amount, bookkeepingKey);
        return super.increment(name, amount);
    }

    private String bookkeepingKeyFor(String counterName) {
        return "metric_meta.aggregatecounters." + counterName;
    }

    private void doIncrementHash(String key, String hashKey, long amount, String bookkeepingKey) {
        long newValue = this.hashOperations.increment((Object)key, (Object)hashKey, amount);
        if (newValue == amount) {
            this.setOperations.add((Object)bookkeepingKey, (Object[])new String[]{key});
        }
    }

    @Override
    public AggregateCount getCounts(String name, int nCounts, AggregateCountResolution resolution) {
        return this.getCounts(name, nCounts, new DateTime(), resolution);
    }

    @Override
    public AggregateCount getCounts(String name, int nCounts, DateTime endDate, AggregateCountResolution resolution) {
        Assert.notNull((Object)endDate, (String)"endDate cannot be null");
        return this.getCounts(name, new Interval((ReadableInstant)resolution.minus(endDate, nCounts - 1), (ReadableInstant)endDate), resolution);
    }

    @Override
    public AggregateCount getCounts(String name, Interval interval, AggregateCountResolution resolution) {
        long[] counts;
        DateTime end = interval.getEnd();
        Chronology c = interval.getChronology();
        if (resolution == AggregateCountResolution.minute) {
            MutableDateTime dt = new MutableDateTime((Object)interval.getStart());
            dt.setRounding(c.hourOfDay());
            Duration step = Duration.standardHours((long)1L);
            ArrayList<long[]> hours = new ArrayList<long[]>();
            while (dt.isBefore((ReadableInstant)end) || dt.isEqual((ReadableInstant)end)) {
                hours.add(this.getMinCountsForHour(name, (ReadableDateTime)dt));
                dt.add((ReadableDuration)step);
            }
            counts = MetricUtils.concatArrays(hours, interval.getStart().getMinuteOfHour(), interval.toPeriod().toStandardMinutes().getMinutes() + 1);
        } else if (resolution == AggregateCountResolution.hour) {
            DateTime cursor = new DateTime(c.dayOfMonth().roundFloor(interval.getStart().getMillis()));
            ArrayList<long[]> days = new ArrayList<long[]>();
            Duration step = Duration.standardHours((long)24L);
            while (cursor.isBefore((ReadableInstant)end)) {
                days.add(this.getHourCountsForDay(name, cursor));
                cursor = cursor.plus((ReadableDuration)step);
            }
            counts = MetricUtils.concatArrays(days, interval.getStart().getHourOfDay(), interval.toPeriod().toStandardHours().getHours() + 1);
        } else if (resolution == AggregateCountResolution.day) {
            DateTime startDay = new DateTime(c.dayOfYear().roundFloor(interval.getStart().getMillis()));
            DateTime endDay = new DateTime(c.dayOfYear().roundFloor(end.plusDays(1).getMillis()));
            int nDays = Days.daysBetween((ReadableInstant)startDay, (ReadableInstant)endDay).getDays();
            DateTime cursor = new DateTime(c.monthOfYear().roundFloor(interval.getStart().getMillis()));
            ArrayList<long[]> months = new ArrayList<long[]>();
            DateTime endMonth = new DateTime(c.monthOfYear().roundCeiling(interval.getEnd().plusMonths(1).getMillis()));
            while (cursor.isBefore((ReadableInstant)endMonth)) {
                months.add(this.getDayCountsForMonth(name, cursor));
                cursor = cursor.plusMonths(1);
            }
            counts = MetricUtils.concatArrays(months, interval.getStart().getDayOfMonth() - 1, nDays);
        } else if (resolution == AggregateCountResolution.month) {
            DateTime startMonth = new DateTime(c.monthOfYear().roundFloor(interval.getStartMillis()));
            DateTime endMonth = new DateTime(c.monthOfYear().roundFloor(end.plusMonths(1).getMillis()));
            int nMonths = Months.monthsBetween((ReadableInstant)startMonth, (ReadableInstant)endMonth).getMonths();
            DateTime cursor = new DateTime(c.year().roundFloor(interval.getStartMillis()));
            ArrayList<long[]> years = new ArrayList<long[]>();
            DateTime endYear = new DateTime(c.year().roundCeiling(interval.getEnd().plusYears(1).getMillis()));
            while (cursor.isBefore((ReadableInstant)endYear)) {
                years.add(this.getMonthCountsForYear(name, cursor));
                cursor = cursor.plusYears(1);
            }
            counts = MetricUtils.concatArrays(years, interval.getStart().getMonthOfYear() - 1, nMonths);
        } else if (resolution == AggregateCountResolution.year) {
            DateTime startYear = new DateTime(interval.getStart().getYear(), 1, 1, 0, 0);
            DateTime endYear = new DateTime(end.getYear() + 1, 1, 1, 0, 0);
            int nYears = Years.yearsBetween((ReadableInstant)startYear, (ReadableInstant)endYear).getYears();
            Map<String, Long> yearCounts = this.getYearCounts(name);
            counts = new long[nYears];
            for (int i = 0; i < nYears; ++i) {
                int year = startYear.plusYears(i).getYear();
                Long count = yearCounts.get(Integer.toString(year));
                if (count == null) {
                    count = 0L;
                }
                counts[i] = count;
            }
        } else {
            throw new IllegalStateException("Shouldn't happen. Unhandled resolution: " + (Object)((Object)resolution));
        }
        return new AggregateCount(name, interval, counts, resolution);
    }

    private Map<String, Long> getYearCounts(String name) {
        AggregateKeyGenerator akg = new AggregateKeyGenerator(this.getPrefix(), name, (ReadableDateTime)new DateTime());
        return this.getEntries(akg.getYearsKey());
    }

    private long[] getMonthCountsForYear(String name, DateTime year) {
        AggregateKeyGenerator akg = new AggregateKeyGenerator(this.getPrefix(), name, (ReadableDateTime)year);
        return this.convertToArray(this.getEntries(akg.getYearKey()), year.monthOfYear().getMaximumValue(), true);
    }

    private long[] getDayCountsForMonth(String name, DateTime month) {
        AggregateKeyGenerator akg = new AggregateKeyGenerator(this.getPrefix(), name, (ReadableDateTime)month.withTimeAtStartOfDay());
        return this.convertToArray(this.getEntries(akg.getMonthKey()), month.dayOfMonth().getMaximumValue(), true);
    }

    private long[] getHourCountsForDay(String name, DateTime day) {
        AggregateKeyGenerator akg = new AggregateKeyGenerator(this.getPrefix(), name, (ReadableDateTime)day.withTimeAtStartOfDay());
        return this.convertToArray(this.getEntries(akg.getDayKey()), 24, false);
    }

    private long[] getMinCountsForHour(String name, ReadableDateTime dateTime) {
        return this.getMinCountsForHour(name, dateTime.getYear(), dateTime.getMonthOfYear(), dateTime.getDayOfMonth(), dateTime.getHourOfDay());
    }

    private long[] getMinCountsForHour(String name, int year, int month, int day, int hour) {
        DateTime dt = new DateTime().withYear(year).withMonthOfYear(month).withDayOfMonth(day).withHourOfDay(hour);
        AggregateKeyGenerator akg = new AggregateKeyGenerator(this.getPrefix(), name, (ReadableDateTime)dt);
        return this.convertToArray(this.getEntries(akg.getHourKey()), 60, false);
    }

    private Map<String, Long> getEntries(String key) {
        return this.hashOperations.entries((Object)key);
    }

    private long[] convertToArray(Map<String, Long> map, int size, boolean unitOffset) {
        long[] values = new long[size];
        int arrayOffset = unitOffset ? -1 : 0;
        for (Map.Entry<String, Long> cursor : map.entrySet()) {
            int offset = Integer.parseInt(cursor.getKey()) + arrayOffset;
            values[offset] = cursor.getValue();
        }
        return values;
    }

    @Override
    public void delete(String id) {
        String metricMetaKey = this.bookkeepingKeyFor(id);
        super.delete(id);
        Set otherKeys = this.setOperations.members((Object)metricMetaKey);
        otherKeys.add(metricMetaKey);
        this.redisOperations.delete((Collection)otherKeys);
    }
}

