/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.analytics.metrics.redis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.retry.RetryOperations;
import org.springframework.util.Assert;
import org.springframework.xd.analytics.metrics.core.Metric;
import org.springframework.xd.analytics.metrics.core.MetricRepository;
import org.springframework.xd.analytics.metrics.redis.RedisUtils;

abstract class AbstractRedisMetricRepository<M extends Metric, V>
implements MetricRepository<M> {
    private final String metricPrefix;
    private final ValueOperations<String, V> valueOperations;
    private final RedisOperations<String, V> redisOperations;

    public ValueOperations<String, V> getValueOperations() {
        return this.valueOperations;
    }

    public RedisOperations<String, V> getRedisOperations() {
        return this.redisOperations;
    }

    AbstractRedisMetricRepository(RedisConnectionFactory connectionFactory, String metricPrefix, Class<V> valueClass) {
        this(connectionFactory, metricPrefix, valueClass, null);
    }

    AbstractRedisMetricRepository(RedisConnectionFactory connectionFactory, String metricPrefix, Class<V> valueClass, RetryOperations retryOperations) {
        Assert.notNull((Object)connectionFactory);
        Assert.hasText((String)metricPrefix, (String)"metric prefix cannot be empty");
        this.metricPrefix = metricPrefix;
        this.redisOperations = RedisUtils.createRedisRetryTemplate(connectionFactory, valueClass, retryOperations);
        this.valueOperations = this.redisOperations.opsForValue();
    }

    public void deleteAll() {
        Set keys = this.redisOperations.keys((Object)(this.metricPrefix + "*"));
        if (keys.size() > 0) {
            this.redisOperations.delete((Collection)keys);
        }
    }

    abstract M create(String var1, V var2);

    abstract V defaultValue();

    abstract V value(M var1);

    protected String getMetricKey(String metricName) {
        return this.metricPrefix + metricName;
    }

    public <S extends M> S save(S metric) {
        String metricKey = this.getMetricKey(metric.getName());
        this.valueOperations.set((Object)metricKey, this.value(metric));
        return metric;
    }

    public <S extends M> Iterable<S> save(Iterable<S> metrics) {
        ArrayList<Metric> results = new ArrayList<Metric>();
        for (Metric m : metrics) {
            results.add(this.save((S)m));
        }
        return results;
    }

    public void delete(String name) {
        Assert.notNull((Object)name, (String)"The name of the metric must not be null");
        this.redisOperations.delete((Object)this.getMetricKey(name));
    }

    public void delete(M metric) {
        Assert.notNull(metric, (String)"The metric must not be null");
        this.redisOperations.delete((Object)this.getMetricKey(metric.getName()));
    }

    public void delete(Iterable<? extends M> metrics) {
        for (Metric metric : metrics) {
            this.delete((M)metric);
        }
    }

    public M findOne(String name) {
        Assert.notNull((Object)name, (String)"The name of the metric must not be null");
        String gaugeKey = this.getMetricKey(name);
        if (this.redisOperations.hasKey((Object)gaugeKey).booleanValue()) {
            Object value = this.valueOperations.get((Object)gaugeKey);
            return this.create(name, value);
        }
        return null;
    }

    public boolean exists(String s) {
        return this.findOne(s) != null;
    }

    public List<M> findAll() {
        ArrayList<M> gauges = new ArrayList<M>();
        Set keys = this.redisOperations.keys((Object)(this.metricPrefix + "*"));
        for (String key : keys) {
            if (key.matches(this.metricPrefix + ".+?_\\d{4}\\.\\d{2}\\.\\d{2}-\\d{2}:\\d{2}")) continue;
            Object value = this.valueOperations.get((Object)key);
            String name = key.substring(this.metricPrefix.length());
            M m = this.create(name, value);
            gauges.add(m);
        }
        return gauges;
    }

    public Iterable<M> findAll(Iterable<String> keys) {
        ArrayList<M> results = new ArrayList<M>();
        for (String k : keys) {
            M value = this.findOne(k);
            if (value == null) continue;
            results.add(value);
        }
        return results;
    }

    public long count() {
        return this.findAll().size();
    }
}

