/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.analytics.metrics.memory;

import org.springframework.util.Assert;
import org.springframework.xd.analytics.metrics.core.MetricUtils;
import org.springframework.xd.analytics.metrics.core.RichGauge;
import org.springframework.xd.analytics.metrics.core.RichGaugeRepository;
import org.springframework.xd.analytics.metrics.memory.InMemoryMetricRepository;

public class InMemoryRichGaugeRepository
extends InMemoryMetricRepository<RichGauge>
implements RichGaugeRepository {
    @Override
    public void recordValue(String name, double value, double alpha) {
        RichGauge gauge = this.getOrCreate(name);
        MetricUtils.setRichGaugeValue(gauge, value, alpha);
    }

    @Override
    public void reset(String name) {
        RichGauge gauge = this.getOrCreate(name);
        MetricUtils.setRichGaugeValue(gauge, 0.0, -1.0);
    }

    @Override
    protected RichGauge getOrCreate(String name) {
        Assert.notNull((Object)name, (String)"Gauge name can not be null");
        RichGauge gauge = (RichGauge)this.findOne(name);
        if (gauge == null) {
            gauge = new RichGauge(name);
            this.save(gauge);
        }
        return gauge;
    }

    @Override
    protected RichGauge create(String name) {
        return new RichGauge(name);
    }
}

