/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.analytics.metrics.memory;

import org.springframework.util.Assert;
import org.springframework.xd.analytics.metrics.core.Gauge;
import org.springframework.xd.analytics.metrics.core.GaugeRepository;
import org.springframework.xd.analytics.metrics.core.MetricUtils;
import org.springframework.xd.analytics.metrics.memory.InMemoryMetricRepository;

public final class InMemoryGaugeRepository
extends InMemoryMetricRepository<Gauge>
implements GaugeRepository {
    @Override
    protected Gauge create(String name) {
        return new Gauge(name);
    }

    @Override
    protected Gauge getOrCreate(String name) {
        Assert.notNull((Object)name, (String)"Gauge name can not be null");
        Gauge gauge = (Gauge)this.findOne(name);
        if (gauge == null) {
            gauge = new Gauge(name);
            this.save(gauge);
        }
        return gauge;
    }

    @Override
    public void recordValue(String name, long value) {
        Gauge gauge = this.getOrCreate(name);
        MetricUtils.setGaugeValue(gauge, value);
    }

    @Override
    public void reset(String name) {
        Gauge gauge = this.getOrCreate(name);
        MetricUtils.setGaugeValue(gauge, 0L);
    }
}

