/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.analytics.metrics.memory;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.xd.analytics.metrics.core.Counter;
import org.springframework.xd.analytics.metrics.core.CounterRepository;
import org.springframework.xd.store.AbstractInMemoryRepository;

@Qualifier(value="simple")
public class InMemoryCounterRepository
extends AbstractInMemoryRepository<Counter, String>
implements CounterRepository {
    @Override
    public long increment(String name) {
        return this.increment(name, 1L);
    }

    @Override
    public long increment(String name, long amount) {
        Counter c = this.getOrCreate(name);
        return c.increment(amount);
    }

    @Override
    public synchronized long decrement(String name) {
        Counter c = this.getOrCreate(name);
        return c.decrement(1L);
    }

    @Override
    public synchronized void reset(String name) {
        this.save(new Counter(name));
    }

    private synchronized Counter getOrCreate(String name) {
        Counter result = (Counter)this.findOne(name);
        if (result == null) {
            result = new Counter(name);
            result = this.save(result);
        }
        return result;
    }

    @Override
    protected String keyFor(Counter entity) {
        return entity.getName();
    }
}

