/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.analytics.metrics.integration;

import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.xd.analytics.metrics.core.CounterRepository;
import org.springframework.xd.analytics.metrics.integration.AbstractMetricHandler;

public class MessageCounterHandler
extends AbstractMetricHandler {
    private final CounterRepository counterRepository;

    public MessageCounterHandler(CounterRepository counterRepository, String nameExpression) {
        super(nameExpression);
        Assert.notNull((Object)counterRepository, (String)"Counter Repository can not be null");
        this.counterRepository = counterRepository;
    }

    @ServiceActivator
    public Message<?> process(Message<?> message) {
        if (message != null) {
            this.counterRepository.increment(this.computeMetricName(message));
        }
        return message;
    }
}

