/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.analytics.metrics.integration;

import java.text.ParseException;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.springframework.expression.Expression;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.xd.analytics.metrics.core.AggregateCounterRepository;
import org.springframework.xd.analytics.metrics.integration.AbstractMetricHandler;

public class AggregateCounterHandler
extends AbstractMetricHandler {
    private final AggregateCounterRepository aggregateCounterRepository;
    private DateTimeFormatter dateFormat = ISODateTimeFormat.dateTime();
    private final Expression incrementExpression;

    public AggregateCounterHandler(AggregateCounterRepository aggregateCounterRepository, String nameExpression, String incrementExpression) {
        super(nameExpression);
        Assert.notNull((Object)aggregateCounterRepository, (String)"Aggregate Counter Repository can not be null");
        Assert.notNull((Object)incrementExpression, (String)"Increment expression can not be null");
        this.aggregateCounterRepository = aggregateCounterRepository;
        this.incrementExpression = this.spelExpressionParser.parseExpression(incrementExpression);
    }

    public void setDateFormat(String pattern) {
        Assert.hasText((String)pattern, (String)"dateFormat pattern must not be empty");
        this.dateFormat = DateTimeFormat.forPattern((String)pattern);
    }

    public Message<?> process(Message<?> message, String timeField) throws ParseException {
        if (message == null) {
            return null;
        }
        Double increment = (Double)this.incrementExpression.getValue(this.evaluationContext, message, Double.class);
        String counterName = this.computeMetricName(message);
        if (timeField == null) {
            this.aggregateCounterRepository.increment(counterName, increment.longValue());
        } else {
            this.aggregateCounterRepository.increment(counterName, increment.longValue(), this.dateFormat.parseDateTime(timeField));
        }
        return message;
    }
}

