/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.sax;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.core.io.Resource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class SaxUtils {
    private static final Log logger = LogFactory.getLog(SaxUtils.class);

    public static XMLReader namespaceAwareXmlReader() throws SAXException {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(true);
            return parserFactory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static InputSource createInputSource(Resource resource) throws IOException {
        InputSource inputSource = new InputSource(resource.getInputStream());
        inputSource.setSystemId(SaxUtils.getSystemId(resource));
        return inputSource;
    }

    public static @Nullable String getSystemId(Resource resource) {
        try {
            return new URI(resource.getURL().toExternalForm()).toString();
        }
        catch (IOException | URISyntaxException ex) {
            logger.debug((Object)("Could not get System ID from [" + String.valueOf(resource) + "], ex"));
            return null;
        }
    }
}

