/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.springframework.util.Assert;

public abstract class TransportInputStream
extends InputStream {
    private InputStream inputStream;

    protected TransportInputStream() {
    }

    private InputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = this.createInputStream();
            Assert.notNull((Object)this.inputStream, (String)"inputStream must not be null");
        }
        return this.inputStream;
    }

    public void close() throws IOException {
        this.getInputStream().close();
    }

    public int available() throws IOException {
        return this.getInputStream().available();
    }

    public synchronized void mark(int readlimit) {
        try {
            this.getInputStream().mark(readlimit);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean markSupported() {
        try {
            return this.getInputStream().markSupported();
        }
        catch (IOException e) {
            return false;
        }
    }

    public int read(byte[] b) throws IOException {
        return this.getInputStream().read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.getInputStream().read(b, off, len);
    }

    public synchronized void reset() throws IOException {
        this.getInputStream().reset();
    }

    public long skip(long n) throws IOException {
        return this.getInputStream().skip(n);
    }

    public int read() throws IOException {
        return this.getInputStream().read();
    }

    protected abstract InputStream createInputStream() throws IOException;

    public abstract Iterator getHeaderNames() throws IOException;

    public abstract Iterator getHeaders(String var1) throws IOException;
}

