/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.saaj;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.transform.Source;
import org.springframework.util.Assert;
import org.springframework.ws.soap.SoapElement;
import org.springframework.ws.soap.saaj.Saaj11Implementation;
import org.springframework.ws.soap.saaj.Saaj12Implementation;
import org.springframework.ws.soap.saaj.Saaj13Implementation;
import org.springframework.ws.soap.saaj.SaajImplementation;
import org.springframework.ws.soap.saaj.SaajSoapElementException;
import org.springframework.ws.soap.saaj.support.SaajUtils;

class SaajSoapElement
implements SoapElement {
    private final SOAPElement element;

    public SaajSoapElement(SOAPElement element) {
        Assert.notNull((Object)element, (String)"element must not be null");
        this.element = element;
    }

    public Source getSource() {
        return this.getImplementation().getSource(this.element);
    }

    public QName getName() {
        return this.getImplementation().getName(this.element);
    }

    public void addAttribute(QName name, String value) {
        try {
            this.getImplementation().addAttribute(this.element, name, value);
        }
        catch (SOAPException ex) {
            throw new SaajSoapElementException(ex);
        }
    }

    public void removeAttribute(QName name) {
        try {
            this.getImplementation().removeAttribute(this.element, name);
        }
        catch (SOAPException ex) {
            throw new SaajSoapElementException(ex);
        }
    }

    public String getAttributeValue(QName name) {
        try {
            return this.getImplementation().getAttributeValue(this.element, name);
        }
        catch (SOAPException ex) {
            throw new SaajSoapElementException(ex);
        }
    }

    public Iterator getAllAttributes() {
        return this.getImplementation().getAllAttibutes(this.element);
    }

    protected final SOAPElement getSaajElement() {
        return this.element;
    }

    protected final SaajImplementation getImplementation() {
        if (SaajUtils.getSaajVersion() == 2) {
            return Saaj13Implementation.getInstance();
        }
        if (SaajUtils.getSaajVersion() == 1) {
            return Saaj12Implementation.getInstance();
        }
        if (SaajUtils.getSaajVersion() == 0) {
            return Saaj11Implementation.getInstance();
        }
        throw new IllegalStateException("Could not find SAAJ on the classpath");
    }
}

