/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.interceptor;

import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.EndpointInterceptor;
import org.springframework.xml.transform.ResourceSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class PayloadTransformingInterceptor
implements EndpointInterceptor,
InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)PayloadTransformingInterceptor.class);
    private Resource requestXslt;
    private Resource responseXslt;
    private Templates requestTemplates;
    private Templates responseTemplates;

    public void setRequestXslt(Resource requestXslt) {
        this.requestXslt = requestXslt;
    }

    public void setResponseXslt(Resource responseXslt) {
        this.responseXslt = responseXslt;
    }

    public boolean handleRequest(MessageContext messageContext, Object endpoint) throws Exception {
        if (this.requestTemplates != null) {
            WebServiceMessage request = messageContext.getRequest();
            Transformer transformer = this.requestTemplates.newTransformer();
            transformer.transform(request.getPayloadSource(), request.getPayloadResult());
            logger.debug((Object)"Request message transformed");
        }
        return true;
    }

    public boolean handleResponse(MessageContext messageContext, Object endpoint) throws Exception {
        if (this.responseTemplates != null) {
            WebServiceMessage response = messageContext.getResponse();
            Transformer transformer = this.responseTemplates.newTransformer();
            transformer.transform(response.getPayloadSource(), response.getPayloadResult());
            logger.debug((Object)"Response message transformed");
        }
        return true;
    }

    public boolean handleFault(MessageContext messageContext, Object endpoint) throws Exception {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.requestXslt == null && this.responseXslt == null) {
            throw new IllegalArgumentException("Setting either 'requestXslt' or 'responseXslt' is required");
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        if (this.requestXslt != null) {
            Assert.isTrue((boolean)this.requestXslt.exists(), (String)("requestXslt \"" + this.requestXslt + "\" does not exit"));
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Transforming request using " + this.requestXslt));
            }
            ResourceSource requestSource = new ResourceSource(xmlReader, this.requestXslt);
            this.requestTemplates = transformerFactory.newTemplates(requestSource);
        }
        if (this.responseXslt != null) {
            Assert.isTrue((boolean)this.responseXslt.exists(), (String)("responseXslt \"" + this.responseXslt + "\" does not exit"));
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Transforming response using " + this.responseXslt));
            }
            ResourceSource responseSource = new ResourceSource(xmlReader, this.responseXslt);
            this.responseTemplates = transformerFactory.newTemplates(responseSource);
        }
    }
}

