/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.validation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.binding.expression.EvaluationException;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.mapping.MappingResults;
import org.springframework.binding.message.MessageContext;
import org.springframework.binding.message.MessageContextErrors;
import org.springframework.binding.validation.ValidationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.SmartValidator;
import org.springframework.validation.Validator;
import org.springframework.webflow.definition.TransitionDefinition;
import org.springframework.webflow.execution.FlowExecutionException;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.validation.BeanValidationHintResolver;
import org.springframework.webflow.validation.DefaultValidationContext;
import org.springframework.webflow.validation.ValidationHintResolver;

public class ValidationHelper {
    private static final Log logger = LogFactory.getLog(ValidationHelper.class);
    private final Object model;
    private final RequestContext requestContext;
    private final String eventId;
    private final String modelName;
    private final ExpressionParser expressionParser;
    private final MessageCodesResolver messageCodesResolver;
    private final MappingResults mappingResults;
    private Validator validator;
    private Object[] validationHints;

    public ValidationHelper(Object model, RequestContext requestContext, String eventId, String modelName, ExpressionParser expressionParser, MessageCodesResolver messageCodesResolver, MappingResults mappingResults, ValidationHintResolver hintResolver) {
        Assert.notNull((Object)model, (String)"The model to validate is required");
        Assert.notNull((Object)requestContext, (String)"The request context for the validator is required");
        this.model = model;
        this.requestContext = requestContext;
        this.eventId = eventId;
        this.modelName = modelName;
        this.expressionParser = expressionParser;
        this.messageCodesResolver = messageCodesResolver;
        this.mappingResults = mappingResults;
        this.validationHints = ValidationHelper.initValidationHints(model, requestContext, eventId, hintResolver);
    }

    public ValidationHelper(Object model, RequestContext requestContext, String eventId, String modelName, ExpressionParser expressionParser, MessageCodesResolver messageCodesResolver, MappingResults mappingResults) {
        this(model, requestContext, eventId, modelName, expressionParser, messageCodesResolver, mappingResults, new BeanValidationHintResolver());
    }

    private static Object[] initValidationHints(Object model, RequestContext requestContext, String eventId, ValidationHintResolver hintResolver) {
        Expression expr = null;
        TransitionDefinition transition = requestContext.getMatchingTransition(eventId);
        if (transition != null) {
            expr = (Expression)transition.getAttributes().get("validationHints");
        }
        if (expr == null) {
            expr = (Expression)requestContext.getCurrentState().getAttributes().get("validationHints");
        }
        if (expr == null) {
            return null;
        }
        String flowId = requestContext.getActiveFlow().getId();
        String stateId = requestContext.getCurrentState().getId();
        try {
            Object hintsValue = expr.getValue((Object)requestContext);
            if (hintsValue instanceof String) {
                String[] hints = StringUtils.commaDelimitedListToStringArray((String)((String)hintsValue));
                return hintResolver.resolveValidationHints(model, flowId, stateId, hints);
            }
            if (hintsValue instanceof Object[]) {
                return (Object[])hintsValue;
            }
            throw new FlowExecutionException(flowId, stateId, "Failed to resolve validation hints [" + String.valueOf(hintsValue) + "]");
        }
        catch (EvaluationException e) {
            throw new FlowExecutionException(flowId, stateId, "Failed to resolve validation hints expression [" + String.valueOf(expr) + "]", e);
        }
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public void setValidationHints(Object[] validationHints) {
        this.validationHints = validationHints;
    }

    public void validate() {
        if (this.validator != null) {
            this.invokeValidatorDefaultValidateMethod(this.validator);
        }
        this.invokeModelValidationMethod(this.model);
        Object modelValidator = this.getModelValidator();
        if (modelValidator != null) {
            this.invokeModelValidator(modelValidator);
        }
    }

    private void invokeModelValidationMethod(Object model) {
        this.invokeValidateMethodForCurrentState(model);
        this.invokeDefaultValidateMethod(model);
    }

    private boolean invokeValidateMethodForCurrentState(Object model) {
        String methodName = "validate" + StringUtils.capitalize((String)this.requestContext.getCurrentState().getId());
        Method validateMethod = ReflectionUtils.findMethod(model.getClass(), (String)methodName, (Class[])new Class[]{ValidationContext.class});
        if (validateMethod != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoking current state model validation method '" + methodName + "(ValidationContext)'"));
            }
            ReflectionUtils.invokeMethod((Method)validateMethod, (Object)model, (Object[])new Object[]{new DefaultValidationContext(this.requestContext, this.eventId, this.mappingResults)});
            return true;
        }
        validateMethod = ReflectionUtils.findMethod(model.getClass(), (String)methodName, (Class[])new Class[]{MessageContext.class});
        if (validateMethod != null) {
            ReflectionUtils.invokeMethod((Method)validateMethod, (Object)model, (Object[])new Object[]{this.requestContext.getMessageContext()});
            return true;
        }
        validateMethod = ReflectionUtils.findMethod(model.getClass(), (String)methodName, (Class[])new Class[]{Errors.class});
        if (validateMethod != null) {
            MessageContextErrors errors = new MessageContextErrors(this.requestContext.getMessageContext(), this.modelName, model, this.expressionParser, this.messageCodesResolver, this.mappingResults);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoking current state model validation method '" + methodName + "(Errors)'"));
            }
            ReflectionUtils.invokeMethod((Method)validateMethod, (Object)model, (Object[])new Object[]{errors});
            return true;
        }
        return false;
    }

    private boolean invokeDefaultValidateMethod(Object model) {
        Method validateMethod = ReflectionUtils.findMethod(model.getClass(), (String)"validate", (Class[])new Class[]{ValidationContext.class});
        if (validateMethod != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Invoking default model validation method 'validate(ValidationContext)'");
            }
            ReflectionUtils.invokeMethod((Method)validateMethod, (Object)model, (Object[])new Object[]{new DefaultValidationContext(this.requestContext, this.eventId, this.mappingResults)});
            return true;
        }
        validateMethod = ReflectionUtils.findMethod(model.getClass(), (String)"validate", (Class[])new Class[]{Errors.class});
        if (validateMethod != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Invoking default model validation method 'validate(Errors)'");
            }
            MessageContextErrors errors = new MessageContextErrors(this.requestContext.getMessageContext(), this.modelName, model, this.expressionParser, this.messageCodesResolver, this.mappingResults);
            ReflectionUtils.invokeMethod((Method)validateMethod, (Object)model, (Object[])new Object[]{errors});
            return true;
        }
        return false;
    }

    private Object getModelValidator() {
        String validatorName;
        ApplicationContext beanFactory = this.requestContext.getActiveFlow().getApplicationContext();
        if (beanFactory != null && StringUtils.hasText((String)this.modelName) && beanFactory.containsBean(validatorName = this.modelName + "Validator")) {
            return beanFactory.getBean(validatorName);
        }
        return null;
    }

    private void invokeModelValidator(Object validator) {
        this.invokeValidatorValidateMethodForCurrentState(validator);
        this.invokeValidatorDefaultValidateMethod(validator);
    }

    private boolean invokeValidatorValidateMethodForCurrentState(Object validator) {
        String methodName = "validate" + StringUtils.capitalize((String)this.requestContext.getCurrentState().getId());
        Method validateMethod = this.findValidationMethod(this.model, validator, methodName, ValidationContext.class);
        if (validateMethod != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoking current state validator method '" + ClassUtils.getShortName(validator.getClass()) + "." + methodName + "(" + ClassUtils.getShortName(this.model.getClass()) + ", ValidationContext)'"));
            }
            ReflectionUtils.invokeMethod((Method)validateMethod, (Object)validator, (Object[])new Object[]{this.model, new DefaultValidationContext(this.requestContext, this.eventId, this.mappingResults)});
            return true;
        }
        validateMethod = this.findValidationMethod(this.model, validator, methodName, Errors.class);
        if (validateMethod != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoking current state validator method '" + ClassUtils.getShortName(validator.getClass()) + "." + methodName + "(" + ClassUtils.getShortName(this.model.getClass()) + ", Errors)'"));
            }
            MessageContextErrors errors = new MessageContextErrors(this.requestContext.getMessageContext(), this.modelName, this.model, this.expressionParser, this.messageCodesResolver, this.mappingResults);
            ReflectionUtils.invokeMethod((Method)validateMethod, (Object)validator, (Object[])new Object[]{this.model, errors});
            return true;
        }
        validateMethod = this.findValidationMethod(this.model, validator, methodName, MessageContext.class);
        if (validateMethod != null) {
            ReflectionUtils.invokeMethod((Method)validateMethod, (Object)validator, (Object[])new Object[]{this.model, this.requestContext.getMessageContext()});
            return true;
        }
        return false;
    }

    private boolean invokeValidatorDefaultValidateMethod(Object validator) {
        if (validator instanceof Validator) {
            Validator springValidator = (Validator)validator;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoking Spring Validator '" + ClassUtils.getShortName(validator.getClass()) + "'"));
            }
            if (springValidator.supports(this.model.getClass())) {
                MessageContextErrors errors = new MessageContextErrors(this.requestContext.getMessageContext(), this.modelName, this.model, this.expressionParser, this.messageCodesResolver, this.mappingResults);
                if (this.validationHints != null) {
                    if (springValidator instanceof SmartValidator) {
                        ((SmartValidator)springValidator).validate(this.model, (Errors)errors, this.validationHints);
                    } else {
                        logger.warn((Object)("Validation hints provided but validator not an instance of SmartValidator: [" + springValidator.getClass().getName() + "]"));
                    }
                } else {
                    springValidator.validate(this.model, (Errors)errors);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Spring Validator '" + ClassUtils.getShortName(validator.getClass()) + "' doesn't support model class " + String.valueOf(this.model.getClass())));
            }
            return true;
        }
        Method validateMethod = this.findValidationMethod(this.model, validator, "validate", ValidationContext.class);
        if (validateMethod != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoking default validator method '" + ClassUtils.getShortName(validator.getClass()) + ".validate(" + ClassUtils.getShortName(this.model.getClass()) + ", ValidationContext)'"));
            }
            ReflectionUtils.invokeMethod((Method)validateMethod, (Object)validator, (Object[])new Object[]{this.model, new DefaultValidationContext(this.requestContext, this.eventId, this.mappingResults)});
            return true;
        }
        validateMethod = this.findValidationMethod(this.model, validator, "validate", Errors.class);
        if (validateMethod != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoking default validator method '" + ClassUtils.getShortName(validator.getClass()) + ".validate(" + ClassUtils.getShortName(this.model.getClass()) + ", Errors)'"));
            }
            MessageContextErrors errors = new MessageContextErrors(this.requestContext.getMessageContext(), this.modelName, this.model, this.expressionParser, this.messageCodesResolver, this.mappingResults);
            ReflectionUtils.invokeMethod((Method)validateMethod, (Object)validator, (Object[])new Object[]{this.model, errors});
            return true;
        }
        return false;
    }

    private Method findValidationMethod(Object model, Object validator, String methodName, Class<?> context) {
        ArrayList modelSearchClasses = new ArrayList();
        for (Class modelClass = AopUtils.getTargetClass((Object)model); modelClass != null; modelClass = modelClass.getSuperclass()) {
            modelSearchClasses.add(modelClass);
        }
        for (Class clazz : modelSearchClasses) {
            Method method = ReflectionUtils.findMethod(validator.getClass(), (String)methodName, (Class[])new Class[]{clazz, context});
            if (method == null) continue;
            return method;
        }
        return null;
    }
}

