/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.core.collection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.binding.collection.MapAccessor;
import org.springframework.core.style.StylerUtils;
import org.springframework.util.Assert;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;

public class LocalAttributeMap<V>
implements MutableAttributeMap<V>,
Serializable {
    private Map<String, V> attributes;
    private transient MapAccessor<String, V> attributeAccessor;

    public LocalAttributeMap() {
        this.initAttributes(this.createTargetMap());
    }

    public LocalAttributeMap(int size, int loadFactor) {
        this.initAttributes(this.createTargetMap(size, loadFactor));
    }

    public LocalAttributeMap(String attributeName, V attributeValue) {
        this.initAttributes(this.createTargetMap(1, 1));
        this.put(attributeName, attributeValue);
    }

    public LocalAttributeMap(Map<String, V> map) {
        Assert.notNull(map, (String)"The target map is required");
        this.initAttributes(map);
    }

    public Map<String, V> asMap() {
        return this.attributeAccessor.asMap();
    }

    @Override
    public int size() {
        return this.attributes.size();
    }

    @Override
    public V get(String attributeName) {
        return this.attributes.get(attributeName);
    }

    @Override
    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    @Override
    public boolean contains(String attributeName) {
        return this.attributes.containsKey(attributeName);
    }

    @Override
    public boolean contains(String attributeName, Class<? extends V> requiredType) throws IllegalArgumentException {
        return this.attributeAccessor.containsKey((Object)attributeName, requiredType);
    }

    @Override
    public V get(String attributeName, V defaultValue) {
        return (V)this.attributeAccessor.get((Object)attributeName, defaultValue);
    }

    @Override
    public <T extends V> T get(String attributeName, Class<T> requiredType) throws IllegalArgumentException {
        return (T)this.attributeAccessor.get((Object)attributeName, requiredType);
    }

    @Override
    public <T extends V> T get(String attributeName, Class<T> requiredType, T defaultValue) throws IllegalStateException {
        return (T)this.attributeAccessor.get((Object)attributeName, requiredType, defaultValue);
    }

    @Override
    public V getRequired(String attributeName) throws IllegalArgumentException {
        return (V)this.attributeAccessor.getRequired((Object)attributeName);
    }

    @Override
    public <T extends V> T getRequired(String attributeName, Class<T> requiredType) throws IllegalArgumentException {
        return (T)this.attributeAccessor.getRequired((Object)attributeName, requiredType);
    }

    @Override
    public String getString(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getString((Object)attributeName);
    }

    @Override
    public String getString(String attributeName, String defaultValue) throws IllegalArgumentException {
        return this.attributeAccessor.getString((Object)attributeName, defaultValue);
    }

    @Override
    public String getRequiredString(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getRequiredString((Object)attributeName);
    }

    @Override
    public Collection<V> getCollection(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getCollection((Object)attributeName);
    }

    @Override
    public <T extends Collection<V>> T getCollection(String attributeName, Class<T> requiredType) throws IllegalArgumentException {
        return (T)this.attributeAccessor.getCollection((Object)attributeName, requiredType);
    }

    @Override
    public Collection<V> getRequiredCollection(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getRequiredCollection((Object)attributeName);
    }

    @Override
    public <T extends Collection<V>> T getRequiredCollection(String attributeName, Class<T> requiredType) throws IllegalArgumentException {
        return (T)this.attributeAccessor.getRequiredCollection((Object)attributeName, requiredType);
    }

    @Override
    public <T extends V> T[] getArray(String attributeName, Class<? extends T[]> requiredType) throws IllegalArgumentException {
        return this.attributeAccessor.getArray((Object)attributeName, requiredType);
    }

    @Override
    public <T extends V> T[] getRequiredArray(String attributeName, Class<? extends T[]> requiredType) throws IllegalArgumentException {
        return this.attributeAccessor.getRequiredArray((Object)attributeName, requiredType);
    }

    @Override
    public <T extends Number> T getNumber(String attributeName, Class<T> requiredType) throws IllegalArgumentException {
        return (T)this.attributeAccessor.getNumber((Object)attributeName, requiredType);
    }

    @Override
    public <T extends Number> T getNumber(String attributeName, Class<T> requiredType, T defaultValue) throws IllegalArgumentException {
        return (T)this.attributeAccessor.getNumber((Object)attributeName, requiredType, defaultValue);
    }

    @Override
    public <T extends Number> T getRequiredNumber(String attributeName, Class<T> requiredType) throws IllegalArgumentException {
        return (T)this.attributeAccessor.getRequiredNumber((Object)attributeName, requiredType);
    }

    @Override
    public Integer getInteger(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getInteger((Object)attributeName);
    }

    @Override
    public Integer getInteger(String attributeName, Integer defaultValue) throws IllegalArgumentException {
        return this.attributeAccessor.getInteger((Object)attributeName, defaultValue);
    }

    @Override
    public Integer getRequiredInteger(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getRequiredInteger((Object)attributeName);
    }

    @Override
    public Long getLong(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getLong((Object)attributeName);
    }

    @Override
    public Long getLong(String attributeName, Long defaultValue) throws IllegalArgumentException {
        return this.attributeAccessor.getLong((Object)attributeName, defaultValue);
    }

    @Override
    public Long getRequiredLong(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getRequiredLong((Object)attributeName);
    }

    @Override
    public Boolean getBoolean(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getBoolean((Object)attributeName);
    }

    @Override
    public Boolean getBoolean(String attributeName, Boolean defaultValue) throws IllegalArgumentException {
        return this.attributeAccessor.getBoolean((Object)attributeName, defaultValue);
    }

    @Override
    public Boolean getRequiredBoolean(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getRequiredBoolean((Object)attributeName);
    }

    @Override
    public AttributeMap<V> union(AttributeMap<? extends V> attributes) {
        if (attributes == null) {
            return new LocalAttributeMap<V>(this.getMapInternal());
        }
        Map<String, V> map = this.createTargetMap();
        map.putAll(this.getMapInternal());
        map.putAll(attributes.asMap());
        return new LocalAttributeMap<V>(map);
    }

    @Override
    public V put(String attributeName, V attributeValue) {
        return this.getMapInternal().put(attributeName, attributeValue);
    }

    @Override
    public MutableAttributeMap<V> putAll(AttributeMap<? extends V> attributes) {
        if (attributes == null) {
            return this;
        }
        this.getMapInternal().putAll(attributes.asMap());
        return this;
    }

    @Override
    public MutableAttributeMap<V> removeAll(MutableAttributeMap<? extends V> attributes) {
        if (attributes == null) {
            return this;
        }
        Map<String, V> internal = this.getMapInternal();
        for (String attribute : attributes.asMap().keySet()) {
            internal.remove(attribute);
        }
        return this;
    }

    @Override
    public Object remove(String attributeName) {
        return this.getMapInternal().remove(attributeName);
    }

    @Override
    public Object extract(String attributeName) {
        Map<String, V> map = this.getMapInternal();
        if (map.containsKey(attributeName)) {
            V value = map.get(attributeName);
            map.remove(attributeName);
            return value;
        }
        return null;
    }

    @Override
    public MutableAttributeMap<V> clear() throws UnsupportedOperationException {
        this.getMapInternal().clear();
        return this;
    }

    @Override
    public MutableAttributeMap<V> replaceWith(AttributeMap<? extends V> attributes) throws UnsupportedOperationException {
        this.clear();
        this.putAll(attributes);
        return this;
    }

    protected void initAttributes(Map<String, V> attributes) {
        this.attributes = attributes;
        this.attributeAccessor = new MapAccessor(this.attributes);
    }

    protected Map<String, V> getMapInternal() {
        return this.attributes;
    }

    protected Map<String, V> createTargetMap() {
        return new HashMap();
    }

    protected Map<String, V> createTargetMap(int size, int loadFactor) {
        return new HashMap(size, loadFactor);
    }

    public boolean equals(Object o) {
        if (!(o instanceof LocalAttributeMap)) {
            return false;
        }
        LocalAttributeMap other = (LocalAttributeMap)o;
        return ((Object)this.getMapInternal()).equals(other.getMapInternal());
    }

    public int hashCode() {
        return ((Object)this.getMapInternal()).hashCode();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.attributeAccessor = new MapAccessor(this.attributes);
    }

    public String toString() {
        return StylerUtils.style(this.attributes);
    }
}

