/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.expression.spel;

import java.util.HashMap;
import java.util.Map;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.webflow.execution.RequestContextHolder;

public class FlowVariablePropertyAccessor
implements PropertyAccessor {
    private static Map variables = new HashMap();

    static {
        variables.put("currentUser", new FlowVariableAccessor(){

            public Object getVariable() {
                return RequestContextHolder.getRequestContext().getExternalContext().getCurrentUser();
            }
        });
        variables.put("flowRequestContext", new FlowVariableAccessor(){

            public Object getVariable() {
                return RequestContextHolder.getRequestContext();
            }
        });
        variables.put("resourceBundle", new FlowVariableAccessor(){

            public Object getVariable() {
                return RequestContextHolder.getRequestContext().getActiveFlow().getApplicationContext();
            }
        });
    }

    public Class[] getSpecificTargetClasses() {
        return null;
    }

    public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
        return variables.containsKey(name);
    }

    public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
        FlowVariableAccessor var = (FlowVariableAccessor)variables.get(name);
        return new TypedValue(var.getVariable());
    }

    public boolean canWrite(EvaluationContext context, Object target, String name) throws AccessException {
        return false;
    }

    public void write(EvaluationContext context, Object target, String name, Object newValue) throws AccessException {
        throw new AccessException(String.valueOf(name) + " is a flow reserved word and cannot be set with an expression.");
    }

    private static interface FlowVariableAccessor {
        public Object getVariable();
    }
}

