/*
 * Copyright 2004-2012 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.binding.convert.converters;

/**
 * A converter that calls the {@link TwoWayConverter#convertTargetToSourceClass(Object, Class)} on a target
 * {@link TwoWayConverter} instance. Useful for invoking the "reverse" (target-to-source) conversion algorithm using the
 * standard Converter contract.
 * 
 * @author Keith Donald
 */
public class ReverseConverter implements Converter {

	private TwoWayConverter converter;

	public ReverseConverter(TwoWayConverter converter) {
		this.converter = converter;
	}

	public Class<?> getSourceClass() {
		return converter.getTargetClass();
	}

	public Class<?> getTargetClass() {
		return converter.getSourceClass();
	}

	public Object convertSourceToTargetClass(Object source, Class<?> targetClass) throws Exception {
		return converter.convertTargetToSourceClass(source, targetClass);
	}

}
