/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.convert.converters;

import java.lang.reflect.Array;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.converters.Converter;

public class ObjectToArray
implements Converter {
    private ConversionService conversionService;
    private ConversionExecutor elementConverter;

    public ObjectToArray(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public ObjectToArray(ConversionExecutor elementConverter) {
        this.elementConverter = elementConverter;
    }

    @Override
    public Class<?> getSourceClass() {
        return Object.class;
    }

    @Override
    public Class<?> getTargetClass() {
        return Object[].class;
    }

    @Override
    public Object convertSourceToTargetClass(Object source, Class<?> targetClass) throws Exception {
        if (source == null) {
            return null;
        }
        Class<?> componentType = targetClass.getComponentType();
        Object array = Array.newInstance(componentType, 1);
        ConversionExecutor converter = this.elementConverter != null ? this.elementConverter : this.conversionService.getConversionExecutor(source.getClass(), componentType);
        Array.set(array, 0, converter.execute(source));
        return array;
    }
}

