/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.scheduling.SchedulingTaskExecutor;
import org.springframework.util.Assert;

public class ThreadPoolTaskExecutor
implements SchedulingTaskExecutor,
Executor,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private int corePoolSize = 1;
    private int maxPoolSize = Integer.MAX_VALUE;
    private int keepAliveSeconds = 60;
    private int queueCapacity = Integer.MAX_VALUE;
    private ThreadFactory threadFactory = Executors.defaultThreadFactory();
    private RejectedExecutionHandler rejectedExecutionHandler = new ThreadPoolExecutor.AbortPolicy();
    private ThreadPoolExecutor executorService;

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void setKeepAliveSeconds(int keepAliveSeconds) {
        this.keepAliveSeconds = keepAliveSeconds;
    }

    public void setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory != null ? threadFactory : Executors.defaultThreadFactory();
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        this.rejectedExecutionHandler = rejectedExecutionHandler != null ? rejectedExecutionHandler : new ThreadPoolExecutor.AbortPolicy();
    }

    public void afterPropertiesSet() {
        this.initialize();
    }

    public void initialize() {
        this.logger.info((Object)"Creating ThreadPoolExecutor");
        BlockingQueue queue = this.createQueue(this.queueCapacity);
        this.executorService = new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, this.keepAliveSeconds, TimeUnit.SECONDS, queue, this.threadFactory, this.rejectedExecutionHandler);
    }

    protected BlockingQueue createQueue(int queueCapacity) {
        if (this.queueCapacity > 0) {
            return new LinkedBlockingQueue(this.queueCapacity);
        }
        return new SynchronousQueue();
    }

    public void execute(Runnable task) {
        Assert.notNull(this.executorService, "ThreadPoolTaskExecutor not initialized");
        this.executorService.execute(task);
    }

    public boolean prefersShortLivedTasks() {
        return true;
    }

    public void destroy() {
        this.shutdown();
    }

    public void shutdown() {
        this.logger.info((Object)"Shutting down ThreadPoolExecutor");
        this.executorService.shutdown();
    }
}

