/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.namedparam;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.ParsedSql;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.util.Assert;

public abstract class NamedParameterUtils {
    public static int countParameterPlaceholders(String sql) {
        if (sql == null) {
            return 0;
        }
        char[] statement = sql.toCharArray();
        boolean withinQuotes = false;
        HashMap<String, StringBuffer> namedParameters = new HashMap<String, StringBuffer>();
        int currentQuote = 45;
        int parameterCount = 0;
        for (int i = 0; i < statement.length; ++i) {
            if (withinQuotes) {
                if (statement[i] != currentQuote) continue;
                withinQuotes = false;
                currentQuote = 45;
                continue;
            }
            if (statement[i] == '\"' || statement[i] == '\'') {
                withinQuotes = true;
                currentQuote = statement[i];
                continue;
            }
            if (statement[i] == ':' || statement[i] == '&') {
                int j;
                StringBuffer parameter = new StringBuffer();
                for (j = i + 1; j < statement.length && NamedParameterUtils.parameterNameContinues(statement, j); ++j) {
                    parameter.append(statement[j]);
                }
                if (j - i <= 1 || namedParameters.containsKey(parameter.toString())) continue;
                ++parameterCount;
                namedParameters.put(parameter.toString(), parameter);
                i = j - 1;
                continue;
            }
            if (statement[i] != '?') continue;
            ++parameterCount;
        }
        return parameterCount;
    }

    public static String parseSqlStatementIntoString(String sql) {
        return NamedParameterUtils.parseSqlStatement(sql).getNewSql();
    }

    static ParsedSql parseSqlStatement(String sql) {
        Assert.notNull(sql, "SQL must not be null");
        ArrayList<String> parameters = new ArrayList<String>();
        HashMap<String, String> namedParameters = new HashMap<String, String>();
        ParsedSql parsedSql = new ParsedSql(sql);
        char[] statement = sql.toCharArray();
        StringBuffer newSql = new StringBuffer();
        boolean withinQuotes = false;
        int currentQuote = 45;
        int namedParameterCount = 0;
        int unnamedParameterCount = 0;
        int totalParameterCount = 0;
        for (int i = 0; i < statement.length; ++i) {
            if (withinQuotes) {
                if (statement[i] == currentQuote) {
                    withinQuotes = false;
                    currentQuote = 45;
                }
                newSql.append(statement[i]);
                continue;
            }
            if (statement[i] == '\"' || statement[i] == '\'') {
                withinQuotes = true;
                currentQuote = statement[i];
                newSql.append(statement[i]);
                continue;
            }
            if (statement[i] == ':' || statement[i] == '&') {
                int j;
                for (j = i + 1; j < statement.length && NamedParameterUtils.parameterNameContinues(statement, j); ++j) {
                }
                if (j - i > 1) {
                    String parameter = sql.substring(i + 1, j);
                    if (!namedParameters.containsKey(parameter)) {
                        namedParameters.put(parameter, parameter);
                        ++namedParameterCount;
                    }
                    newSql.append("?");
                    parameters.add(parameter);
                    ++totalParameterCount;
                } else {
                    newSql.append(statement[i]);
                }
                i = j - 1;
                continue;
            }
            newSql.append(statement[i]);
            if (statement[i] != '?') continue;
            ++unnamedParameterCount;
            ++totalParameterCount;
        }
        parsedSql.setNewSql(newSql.toString());
        parsedSql.setParameterNames(parameters.toArray(new String[parameters.size()]));
        parsedSql.setNamedParameterCount(namedParameterCount);
        parsedSql.setUnnamedParameterCount(unnamedParameterCount);
        parsedSql.setTotalParameterCount(totalParameterCount);
        return parsedSql;
    }

    public static String substituteNamedParameters(String sql, SqlParameterSource paramSource) {
        Assert.notNull(sql, "SQL must not be null");
        char[] statement = sql.toCharArray();
        StringBuffer newSql = new StringBuffer();
        boolean withinQuotes = false;
        int currentQuote = 45;
        for (int i = 0; i < statement.length; ++i) {
            if (withinQuotes) {
                if (statement[i] == currentQuote) {
                    withinQuotes = false;
                    currentQuote = 45;
                }
                newSql.append(statement[i]);
                continue;
            }
            if (statement[i] == '\"' || statement[i] == '\'') {
                withinQuotes = true;
                currentQuote = statement[i];
                newSql.append(statement[i]);
                continue;
            }
            if (statement[i] == ':' || statement[i] == '&') {
                int j;
                for (j = i + 1; j < statement.length && NamedParameterUtils.parameterNameContinues(statement, j); ++j) {
                }
                if (j - i > 1) {
                    String paramName = sql.substring(i + 1, j);
                    if (paramSource != null && paramSource.hasValue(paramName)) {
                        Object value = paramSource.getValue(paramName);
                        if (value instanceof Collection) {
                            Collection entries = (Collection)value;
                            for (int k = 0; k < entries.size(); ++k) {
                                if (k > 0) {
                                    newSql.append(", ");
                                }
                                newSql.append("?");
                            }
                        } else {
                            newSql.append("?");
                        }
                    } else {
                        newSql.append("?");
                    }
                } else {
                    newSql.append(statement[i]);
                }
                i = j - 1;
                continue;
            }
            newSql.append(statement[i]);
        }
        return newSql.toString();
    }

    public static Object[] buildValueArray(String sql, Map paramMap) {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement(sql);
        return NamedParameterUtils.buildValueArray(parsedSql, new MapSqlParameterSource(paramMap));
    }

    static Object[] buildValueArray(ParsedSql parsedSql, SqlParameterSource paramSource) {
        Object[] paramArray = new Object[parsedSql.getTotalParameterCount()];
        if (parsedSql.getNamedParameterCount() > 0 && parsedSql.getUnnamedParameterCount() > 0) {
            throw new InvalidDataAccessApiUsageException("You can't mix named and traditional ? placeholders. You have " + parsedSql.getNamedParameterCount() + " named parameter(s) and " + parsedSql.getUnnamedParameterCount() + " traditonal placeholder(s) in [" + parsedSql.getSql() + "]");
        }
        String[] paramNames = parsedSql.getParameterNames();
        for (int i = 0; i < paramNames.length; ++i) {
            String paramName = paramNames[i];
            try {
                paramArray[i] = paramSource.getValue(paramName);
                continue;
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidDataAccessApiUsageException("No value supplied for the SQL parameter '" + paramName + "': " + ex.getMessage());
            }
        }
        return paramArray;
    }

    static int[] buildSqlTypeArray(ParsedSql parsedSql, SqlParameterSource paramSource) {
        int[] sqlTypes = new int[parsedSql.getTotalParameterCount()];
        String[] paramNames = parsedSql.getParameterNames();
        for (int i = 0; i < paramNames.length; ++i) {
            sqlTypes[i] = paramSource.getSqlType(paramNames[i]);
        }
        return sqlTypes;
    }

    private static boolean parameterNameContinues(char[] statement, int pos) {
        return statement[pos] != ' ' && statement[pos] != ',' && statement[pos] != ')' && statement[pos] != '\"' && statement[pos] != '\'' && statement[pos] != '|' && statement[pos] != ';' && statement[pos] != '\n' && statement[pos] != '\r';
    }
}

