/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket;

import java.nio.charset.StandardCharsets;
import org.jspecify.annotations.Nullable;
import org.springframework.web.socket.AbstractWebSocketMessage;

public final class TextMessage
extends AbstractWebSocketMessage<String> {
    private final byte @Nullable [] bytes;

    public TextMessage(CharSequence payload) {
        super(payload.toString(), true);
        this.bytes = null;
    }

    public TextMessage(byte[] payload) {
        super(new String(payload, StandardCharsets.UTF_8));
        this.bytes = payload;
    }

    public TextMessage(CharSequence payload, boolean isLast) {
        super(payload.toString(), isLast);
        this.bytes = null;
    }

    @Override
    public int getPayloadLength() {
        return this.asBytes().length;
    }

    public byte[] asBytes() {
        return this.bytes != null ? this.bytes : ((String)this.getPayload()).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    protected String toStringPayload() {
        String payload = (String)this.getPayload();
        return payload.length() > 10 ? payload.substring(0, 10) + ".." : payload;
    }
}

