/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import io.micrometer.context.ContextSnapshot;
import io.micrometer.context.ContextSnapshotFactory;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskDecorator;
import org.springframework.core.task.TaskExecutor;
import org.springframework.core.task.support.ContextPropagatingTaskDecorator;
import org.springframework.http.MediaType;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.context.request.async.WebAsyncUtils;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyEmitter;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class ReactiveTypeHandler {
    private static final long STREAMING_TIMEOUT_VALUE = -1L;
    private static final MediaType WILDCARD_SUBTYPE_SUFFIXED_BY_NDJSON = MediaType.valueOf((String)"application/*+x-ndjson");
    private static final MediaType APPLICATION_GRPC = MediaType.valueOf((String)"application/grpc");
    private static final boolean isContextPropagationPresent = ClassUtils.isPresent((String)"io.micrometer.context.ContextSnapshot", (ClassLoader)ReactiveTypeHandler.class.getClassLoader());
    private static final Log logger = LogFactory.getLog(ReactiveTypeHandler.class);
    private final ReactiveAdapterRegistry adapterRegistry;
    private final TaskExecutor taskExecutor;
    private final ContentNegotiationManager contentNegotiationManager;
    private final @Nullable Object contextSnapshotHelper;

    public ReactiveTypeHandler() {
        this(ReactiveAdapterRegistry.getSharedInstance(), (TaskExecutor)new SyncTaskExecutor(), new ContentNegotiationManager(), null);
    }

    ReactiveTypeHandler(ReactiveAdapterRegistry registry, TaskExecutor executor, ContentNegotiationManager manager, @Nullable Object contextSnapshotFactory) {
        Assert.notNull((Object)registry, (String)"ReactiveAdapterRegistry is required");
        Assert.notNull((Object)executor, (String)"TaskExecutor is required");
        Assert.notNull((Object)manager, (String)"ContentNegotiationManager is required");
        this.adapterRegistry = registry;
        this.taskExecutor = executor;
        this.contentNegotiationManager = manager;
        this.contextSnapshotHelper = ReactiveTypeHandler.initContextSnapshotHelper(contextSnapshotFactory);
    }

    private static @Nullable Object initContextSnapshotHelper(@Nullable Object snapshotFactory) {
        if (isContextPropagationPresent) {
            return new ContextSnapshotHelper((ContextSnapshotFactory)snapshotFactory);
        }
        return null;
    }

    public boolean isReactiveType(Class<?> type) {
        return this.adapterRegistry.getAdapter(type) != null;
    }

    public @Nullable ResponseBodyEmitter handleValue(Object returnValue, MethodParameter returnType, @Nullable MediaType presetMediaType, ModelAndViewContainer mav, NativeWebRequest request) throws Exception {
        Assert.notNull((Object)returnValue, (String)"Expected return value");
        Class<?> clazz = returnValue.getClass();
        ReactiveAdapter adapter = this.adapterRegistry.getAdapter(clazz);
        Assert.state((adapter != null ? 1 : 0) != 0, () -> "Unexpected return value type: " + String.valueOf(clazz));
        TaskDecorator taskDecorator = null;
        if (isContextPropagationPresent) {
            ContextSnapshotHelper helper = (ContextSnapshotHelper)this.contextSnapshotHelper;
            Assert.notNull((Object)helper, (String)"No ContextSnapshotHelper");
            returnValue = helper.writeReactorContext(returnValue);
            taskDecorator = helper.getTaskDecorator();
        }
        ResolvableType elementType = ResolvableType.forMethodParameter((MethodParameter)returnType).getGeneric(new int[0]);
        Class elementClass = elementType.toClass();
        Collection<MediaType> mediaTypes = presetMediaType != null ? List.of(presetMediaType) : this.getMediaTypes(request);
        Optional<MediaType> mediaType = mediaTypes.stream().filter(MimeType::isConcrete).findFirst();
        if (adapter.isMultiValue()) {
            if (mediaTypes.stream().anyMatch(arg_0 -> ((MediaType)MediaType.TEXT_EVENT_STREAM).includes(arg_0)) || ServerSentEvent.class.isAssignableFrom(elementClass)) {
                SseEmitter emitter = new SseEmitter(-1L);
                new SseEmitterSubscriber(emitter, this.taskExecutor, taskDecorator).connect(adapter, returnValue);
                return emitter;
            }
            if (mediaTypes.stream().anyMatch(arg_0 -> ((MediaType)APPLICATION_GRPC).includes(arg_0))) {
                ResponseBodyEmitter emitter = this.getEmitter(mediaType.orElse(APPLICATION_GRPC));
                new BasicEmitterSubscriber(emitter, APPLICATION_GRPC, this.taskExecutor).connect(adapter, returnValue);
                return emitter;
            }
            if (CharSequence.class.isAssignableFrom(elementClass)) {
                ResponseBodyEmitter emitter = this.getEmitter(mediaType.orElse(MediaType.TEXT_PLAIN));
                new BasicEmitterSubscriber(emitter, MediaType.TEXT_PLAIN, this.taskExecutor).connect(adapter, returnValue);
                return emitter;
            }
            MediaType streamingResponseType = ReactiveTypeHandler.findConcreteJsonStreamMediaType(mediaTypes);
            if (streamingResponseType != null) {
                ResponseBodyEmitter emitter = this.getEmitter(streamingResponseType);
                new JsonEmitterSubscriber(emitter, this.taskExecutor).connect(adapter, returnValue);
                return emitter;
            }
        }
        DeferredResult result = new DeferredResult();
        new DeferredResultSubscriber((DeferredResult<Object>)result, adapter, elementType).connect(adapter, returnValue);
        WebAsyncUtils.getAsyncManager((WebRequest)request).startDeferredResultProcessing(result, new Object[]{mav});
        return null;
    }

    static @Nullable MediaType findConcreteJsonStreamMediaType(Collection<MediaType> acceptedMediaTypes) {
        for (MediaType acceptedType : acceptedMediaTypes) {
            if (WILDCARD_SUBTYPE_SUFFIXED_BY_NDJSON.includes(acceptedType)) {
                if (acceptedType.isConcrete()) {
                    return acceptedType;
                }
                return MediaType.APPLICATION_NDJSON;
            }
            if (!MediaType.APPLICATION_NDJSON.includes(acceptedType)) continue;
            return MediaType.APPLICATION_NDJSON;
        }
        return null;
    }

    private Collection<MediaType> getMediaTypes(NativeWebRequest request) throws HttpMediaTypeNotAcceptableException {
        Collection producibleMediaTypes = (Collection)request.getAttribute(HandlerMapping.PRODUCIBLE_MEDIA_TYPES_ATTRIBUTE, 0);
        return CollectionUtils.isEmpty((Collection)producibleMediaTypes) ? this.contentNegotiationManager.resolveMediaTypes(request) : producibleMediaTypes;
    }

    private ResponseBodyEmitter getEmitter(final MediaType mediaType) {
        return new ResponseBodyEmitter(this, -1L){
            final /* synthetic */ ReactiveTypeHandler this$0;
            {
                this.this$0 = this$0;
                super(timeout);
            }

            @Override
            protected void extendResponse(ServerHttpResponse outputMessage) {
                outputMessage.getHeaders().setContentType(mediaType);
            }
        };
    }

    private static final class ContextSnapshotHelper {
        private final ContextSnapshotFactory snapshotFactory;

        private ContextSnapshotHelper(@Nullable ContextSnapshotFactory factory) {
            this.snapshotFactory = factory != null ? factory : ContextSnapshotFactory.builder().build();
        }

        public Object writeReactorContext(Object returnValue) {
            if (Mono.class.isAssignableFrom(returnValue.getClass())) {
                ContextSnapshot snapshot = this.snapshotFactory.captureAll(new Object[0]);
                return ((Mono)returnValue).contextWrite(arg_0 -> ((ContextSnapshot)snapshot).updateContext(arg_0));
            }
            if (Flux.class.isAssignableFrom(returnValue.getClass())) {
                ContextSnapshot snapshot = this.snapshotFactory.captureAll(new Object[0]);
                return ((Flux)returnValue).contextWrite(arg_0 -> ((ContextSnapshot)snapshot).updateContext(arg_0));
            }
            return returnValue;
        }

        public TaskDecorator getTaskDecorator() {
            return new ContextPropagatingTaskDecorator(this.snapshotFactory);
        }
    }

    private static class SseEmitterSubscriber
    extends AbstractEmitterSubscriber {
        SseEmitterSubscriber(SseEmitter sseEmitter, TaskExecutor executor, @Nullable TaskDecorator taskDecorator) {
            super(sseEmitter, executor, taskDecorator);
        }

        @Override
        protected void send(Object element) throws IOException {
            if (element instanceof ServerSentEvent) {
                ServerSentEvent event = (ServerSentEvent)element;
                ((SseEmitter)this.getEmitter()).send(this.adapt(event));
            } else {
                this.getEmitter().send(element, MediaType.APPLICATION_JSON);
            }
        }

        private SseEmitter.SseEventBuilder adapt(ServerSentEvent<?> sse) {
            SseEmitter.SseEventBuilder builder = SseEmitter.event();
            String id = sse.id();
            String event = sse.event();
            Duration retry = sse.retry();
            String comment = sse.comment();
            Object data = sse.data();
            if (id != null) {
                builder.id(id);
            }
            if (event != null) {
                builder.name(event);
            }
            if (data != null) {
                builder.data(data);
            }
            if (retry != null) {
                builder.reconnectTime(retry.toMillis());
            }
            if (comment != null) {
                builder.comment(comment);
            }
            return builder;
        }
    }

    private static class BasicEmitterSubscriber
    extends AbstractEmitterSubscriber {
        private final MediaType mediaType;

        BasicEmitterSubscriber(ResponseBodyEmitter emitter, MediaType mediaType, TaskExecutor executor) {
            super(emitter, executor, null);
            this.mediaType = mediaType;
        }

        @Override
        protected void send(Object element) throws IOException {
            this.getEmitter().send(element, this.mediaType);
        }
    }

    private static class JsonEmitterSubscriber
    extends AbstractEmitterSubscriber {
        JsonEmitterSubscriber(ResponseBodyEmitter emitter, TaskExecutor executor) {
            super(emitter, executor, null);
        }

        @Override
        protected void send(Object element) throws IOException {
            this.getEmitter().send(element, MediaType.APPLICATION_JSON);
            this.getEmitter().send("\n", MediaType.TEXT_PLAIN);
        }
    }

    private static class DeferredResultSubscriber
    implements Subscriber<Object> {
        private final DeferredResult<Object> result;
        private final boolean multiValueSource;
        private final CollectedValuesList values;

        DeferredResultSubscriber(DeferredResult<Object> result, ReactiveAdapter adapter, ResolvableType elementType) {
            this.result = result;
            this.multiValueSource = adapter.isMultiValue();
            this.values = new CollectedValuesList(elementType);
        }

        public void connect(ReactiveAdapter adapter, Object returnValue) {
            Publisher publisher = adapter.toPublisher(returnValue);
            publisher.subscribe((Subscriber)this);
        }

        public void onSubscribe(Subscription subscription) {
            this.result.onTimeout(() -> ((Subscription)subscription).cancel());
            subscription.request(Long.MAX_VALUE);
        }

        public void onNext(Object element) {
            this.values.add(element);
        }

        public void onError(Throwable ex) {
            this.result.setErrorResult((Object)ex);
        }

        public void onComplete() {
            if (this.values.size() > 1 || this.multiValueSource) {
                this.result.setResult((Object)this.values);
            } else if (this.values.size() == 1) {
                this.result.setResult(this.values.get(0));
            } else {
                this.result.setResult(null);
            }
        }
    }

    static class CollectedValuesList
    extends ArrayList<Object> {
        private final ResolvableType elementType;

        CollectedValuesList(ResolvableType elementType) {
            this.elementType = elementType;
        }

        public ResolvableType getReturnType() {
            return ResolvableType.forClassWithGenerics(List.class, (ResolvableType[])new ResolvableType[]{this.elementType});
        }
    }

    private static abstract class AbstractEmitterSubscriber
    implements Subscriber<Object>,
    Runnable {
        private final ResponseBodyEmitter emitter;
        private final TaskExecutor taskExecutor;
        private @Nullable Subscription subscription;
        private final AtomicReference<Object> elementRef = new AtomicReference();
        private @Nullable Throwable error;
        private volatile boolean terminated;
        private final AtomicLong executing = new AtomicLong();
        private volatile boolean done;
        private final Runnable sendTask;

        protected AbstractEmitterSubscriber(ResponseBodyEmitter emitter, TaskExecutor executor, @Nullable TaskDecorator taskDecorator) {
            this.emitter = emitter;
            this.taskExecutor = executor;
            this.sendTask = taskDecorator != null ? taskDecorator.decorate((Runnable)this) : this;
        }

        public void connect(ReactiveAdapter adapter, Object returnValue) {
            Publisher publisher = adapter.toPublisher(returnValue);
            publisher.subscribe((Subscriber)this);
        }

        protected ResponseBodyEmitter getEmitter() {
            return this.emitter;
        }

        public final void onSubscribe(Subscription subscription) {
            this.subscription = subscription;
            this.emitter.onTimeout(() -> {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Connection timeout for " + String.valueOf(this.emitter)));
                }
                this.terminate();
                this.emitter.complete();
            });
            this.emitter.onError(this.emitter::completeWithError);
            subscription.request(1L);
        }

        public final void onNext(Object element) {
            this.elementRef.lazySet(element);
            this.trySchedule();
        }

        public final void onError(Throwable ex) {
            this.error = ex;
            this.terminated = true;
            this.trySchedule();
        }

        public final void onComplete() {
            this.terminated = true;
            this.trySchedule();
        }

        private void trySchedule() {
            if (this.executing.getAndIncrement() == 0L) {
                this.schedule();
            }
        }

        private void schedule() {
            try {
                this.taskExecutor.execute(this.sendTask);
            }
            catch (Throwable ex) {
                try {
                    this.terminate();
                }
                finally {
                    this.executing.decrementAndGet();
                    this.elementRef.lazySet(null);
                }
            }
        }

        @Override
        public void run() {
            if (this.done) {
                this.elementRef.lazySet(null);
                return;
            }
            boolean isTerminated = this.terminated;
            Object element = this.elementRef.get();
            if (element != null) {
                this.elementRef.lazySet(null);
                Assert.state((this.subscription != null ? 1 : 0) != 0, (String)"No subscription");
                try {
                    this.send(element);
                    this.subscription.request(1L);
                }
                catch (Throwable ex) {
                    block17: {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Send for " + String.valueOf(this.emitter) + " failed: " + String.valueOf(ex)));
                        }
                        this.terminate();
                        try {
                            this.emitter.completeWithError(ex);
                        }
                        catch (Exception ex2) {
                            if (!logger.isDebugEnabled()) break block17;
                            logger.debug((Object)("Failure from emitter completeWithError: " + String.valueOf(ex2)));
                        }
                    }
                    return;
                }
            }
            if (isTerminated) {
                block18: {
                    this.done = true;
                    Throwable ex = this.error;
                    this.error = null;
                    if (ex != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Publisher for " + String.valueOf(this.emitter) + " failed: " + String.valueOf(ex)));
                        }
                        try {
                            this.emitter.completeWithError(ex);
                        }
                        catch (Exception ex2) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Failure from emitter completeWithError: " + String.valueOf(ex2)));
                            }
                            break block18;
                        }
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Publisher for " + String.valueOf(this.emitter) + " completed"));
                    }
                    try {
                        this.emitter.complete();
                    }
                    catch (Exception ex2) {
                        if (!logger.isDebugEnabled()) break block18;
                        logger.debug((Object)("Failure from emitter complete: " + String.valueOf(ex2)));
                    }
                }
                return;
            }
            if (this.executing.decrementAndGet() != 0L) {
                this.schedule();
            }
        }

        protected abstract void send(Object var1) throws IOException;

        private void terminate() {
            this.done = true;
            if (this.subscription != null) {
                this.subscription.cancel();
            }
        }
    }
}

