/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.support;

import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.servlet.support.AbstractDispatcherServletInitializer;

public abstract class AbstractAnnotationConfigDispatcherServletInitializer
extends AbstractDispatcherServletInitializer {
    @Nullable
    protected WebApplicationContext createRootApplicationContext() {
        Object[] configClasses = this.getRootConfigClasses();
        if (!ObjectUtils.isEmpty((Object[])configClasses)) {
            AnnotationConfigWebApplicationContext rootAppContext = new AnnotationConfigWebApplicationContext();
            rootAppContext.register((Class[])configClasses);
            return rootAppContext;
        }
        return null;
    }

    @Override
    protected WebApplicationContext createServletApplicationContext() {
        AnnotationConfigWebApplicationContext servletAppContext = new AnnotationConfigWebApplicationContext();
        Object[] configClasses = this.getServletConfigClasses();
        if (!ObjectUtils.isEmpty((Object[])configClasses)) {
            servletAppContext.register((Class[])configClasses);
        }
        return servletAppContext;
    }

    @Nullable
    protected abstract Class<?>[] getRootConfigClasses();

    @Nullable
    protected abstract Class<?>[] getServletConfigClasses();
}

