/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.MatrixVariable;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.HandlerMapping;

public class MatrixVariableMapMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    public boolean supportsParameter(MethodParameter parameter) {
        MatrixVariable paramAnnot = (MatrixVariable)parameter.getParameterAnnotation(MatrixVariable.class);
        if (paramAnnot != null && Map.class.isAssignableFrom(parameter.getParameterType())) {
            return !StringUtils.hasText((String)paramAnnot.value());
        }
        return false;
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest request, WebDataBinderFactory binderFactory) throws Exception {
        Map matrixVariables = (Map)request.getAttribute(HandlerMapping.MATRIX_VARIABLES_ATTRIBUTE, 0);
        if (CollectionUtils.isEmpty((Map)matrixVariables)) {
            return Collections.emptyMap();
        }
        String pathVariable = ((MatrixVariable)parameter.getParameterAnnotation(MatrixVariable.class)).pathVar();
        if (!pathVariable.equals("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n")) {
            MultiValueMap map = (MultiValueMap)matrixVariables.get(pathVariable);
            return map != null ? map : Collections.emptyMap();
        }
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        for (MultiValueMap vars : matrixVariables.values()) {
            for (String name : vars.keySet()) {
                for (String value : (List)vars.get((Object)name)) {
                    map.add((Object)name, (Object)value);
                }
            }
        }
        return map;
    }
}

