/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.FlashMap;
import org.springframework.web.servlet.FlashMapManager;
import org.springframework.web.util.UrlPathHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFlashMapManager
implements FlashMapManager {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private int flashMapTimeout = 180;
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private static final Object writeLock = new Object();

    public void setFlashMapTimeout(int flashMapTimeout) {
        this.flashMapTimeout = flashMapTimeout;
    }

    public int getFlashMapTimeout() {
        return this.flashMapTimeout;
    }

    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        Assert.notNull((Object)urlPathHelper, (String)"UrlPathHelper must not be null");
        this.urlPathHelper = urlPathHelper;
    }

    public UrlPathHelper getUrlPathHelper() {
        return this.urlPathHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final FlashMap retrieveAndUpdate(HttpServletRequest request, HttpServletResponse response) {
        List<FlashMap> allMaps = this.retrieveFlashMaps(request);
        if (CollectionUtils.isEmpty(allMaps)) {
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Retrieved FlashMap(s): " + allMaps));
        }
        List<FlashMap> mapsToRemove = this.getExpiredFlashMaps(allMaps);
        FlashMap match = this.getMatchingFlashMap(allMaps, request);
        if (match != null) {
            mapsToRemove.add(match);
        }
        if (!mapsToRemove.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Removing FlashMap(s): " + allMaps));
            }
            Object object = writeLock;
            synchronized (object) {
                allMaps = this.retrieveFlashMaps(request);
                allMaps.removeAll(mapsToRemove);
                this.updateFlashMaps(allMaps, request, response);
            }
        }
        return match;
    }

    protected abstract List<FlashMap> retrieveFlashMaps(HttpServletRequest var1);

    private List<FlashMap> getExpiredFlashMaps(List<FlashMap> allMaps) {
        ArrayList<FlashMap> result = new ArrayList<FlashMap>();
        for (FlashMap map : allMaps) {
            if (!map.isExpired()) continue;
            result.add(map);
        }
        return result;
    }

    private FlashMap getMatchingFlashMap(List<FlashMap> allMaps, HttpServletRequest request) {
        ArrayList<FlashMap> result = new ArrayList<FlashMap>();
        for (FlashMap flashMap : allMaps) {
            if (!this.isFlashMapForRequest(flashMap, request)) continue;
            result.add(flashMap);
        }
        if (!result.isEmpty()) {
            Collections.sort(result);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found matching FlashMap(s): " + result));
            }
            return (FlashMap)result.get(0);
        }
        return null;
    }

    protected boolean isFlashMapForRequest(FlashMap flashMap, HttpServletRequest request) {
        String requestUri;
        if (flashMap.getTargetRequestPath() != null && !(requestUri = this.urlPathHelper.getOriginatingRequestUri(request)).equals(flashMap.getTargetRequestPath()) && !requestUri.equals(flashMap.getTargetRequestPath() + "/")) {
            return false;
        }
        MultiValueMap<String, String> targetParams = flashMap.getTargetRequestParams();
        for (String paramName : targetParams.keySet()) {
            for (String targetValue : (List)targetParams.get((Object)paramName)) {
                if (ObjectUtils.containsElement((Object[])request.getParameterValues(paramName), (Object)targetValue)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void saveOutputFlashMap(FlashMap flashMap, HttpServletRequest request, HttpServletResponse response) {
        if (CollectionUtils.isEmpty((Map)flashMap)) {
            return;
        }
        String path = this.decodeAndNormalizePath(flashMap.getTargetRequestPath(), request);
        flashMap.setTargetRequestPath(path);
        flashMap.startExpirationPeriod(this.flashMapTimeout);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Saving FlashMap=" + flashMap));
        }
        Object object = writeLock;
        synchronized (object) {
            CopyOnWriteArrayList<FlashMap> allMaps = this.retrieveFlashMaps(request);
            allMaps = allMaps == null ? new CopyOnWriteArrayList<FlashMap>() : allMaps;
            allMaps.add(flashMap);
            this.updateFlashMaps(allMaps, request, response);
        }
    }

    private String decodeAndNormalizePath(String path, HttpServletRequest request) {
        if (path != null && (path = this.urlPathHelper.decodeRequestString(request, path)).charAt(0) != '/') {
            String requestUri = this.urlPathHelper.getRequestUri(request);
            path = requestUri.substring(0, requestUri.lastIndexOf(47) + 1) + path;
            path = StringUtils.cleanPath((String)path);
        }
        return path;
    }

    protected abstract void updateFlashMaps(List<FlashMap> var1, HttpServletRequest var2, HttpServletResponse var3);
}

