/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.web.context.support.WebApplicationObjectSupport;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;

public abstract class AbstractCachingViewResolver
extends WebApplicationObjectSupport
implements ViewResolver {
    private boolean cache = true;
    private boolean cacheUnresolved = false;
    private final Map<Object, View> viewCache = new HashMap<Object, View>();

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public boolean isCache() {
        return this.cache;
    }

    public void setCacheUnresolved(boolean cacheUnresolved) {
        this.cacheUnresolved = cacheUnresolved;
    }

    public boolean isCacheUnresolved() {
        return this.cacheUnresolved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View resolveViewName(String viewName, Locale locale) throws Exception {
        if (!this.isCache()) {
            return this.createView(viewName, locale);
        }
        Object cacheKey = this.getCacheKey(viewName, locale);
        Map<Object, View> map = this.viewCache;
        synchronized (map) {
            boolean isCached;
            View view = this.viewCache.get(cacheKey);
            boolean bl = isCached = this.cacheUnresolved && this.viewCache.containsKey(cacheKey);
            if (view == null && !isCached) {
                view = this.createView(viewName, locale);
                this.viewCache.put(cacheKey, view);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Cached view [" + cacheKey + "]"));
                }
            }
            return view;
        }
    }

    protected Object getCacheKey(String viewName, Locale locale) {
        return String.valueOf(viewName) + "_" + locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromCache(String viewName, Locale locale) {
        if (!this.cache) {
            this.logger.warn((Object)"View caching is SWITCHED OFF -- removal not necessary");
        } else {
            View cachedView;
            Object cacheKey = this.getCacheKey(viewName, locale);
            Map<Object, View> map = this.viewCache;
            synchronized (map) {
                cachedView = this.viewCache.remove(cacheKey);
            }
            if (cachedView == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("No cached instance for view '" + cacheKey + "' was found"));
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Cache for view " + cacheKey + " has been cleared"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        this.logger.debug((Object)"Clearing entire view cache");
        Map<Object, View> map = this.viewCache;
        synchronized (map) {
            this.viewCache.clear();
        }
    }

    protected View createView(String viewName, Locale locale) throws Exception {
        return this.loadView(viewName, locale);
    }

    protected abstract View loadView(String var1, Locale var2) throws Exception;
}

