/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import javax.servlet.jsp.JspException;
import org.springframework.web.servlet.tags.form.AbstractHtmlInputElementTag;
import org.springframework.web.servlet.tags.form.SelectedValueComparator;
import org.springframework.web.servlet.tags.form.TagIdGenerator;
import org.springframework.web.servlet.tags.form.TagWriter;

public abstract class AbstractCheckedElementTag
extends AbstractHtmlInputElementTag {
    protected void renderFromValue(Object value, TagWriter tagWriter) throws JspException {
        this.renderFromValue(value, value, tagWriter);
    }

    protected void renderFromValue(Object item, Object value, TagWriter tagWriter) throws JspException {
        String displayValue = this.convertToDisplayString(value);
        tagWriter.writeAttribute("value", this.processFieldValue(this.getName(), displayValue, this.getInputType()));
        if (this.isOptionSelected(value) || value != item && this.isOptionSelected(item)) {
            tagWriter.writeAttribute("checked", "checked");
        }
    }

    private boolean isOptionSelected(Object value) throws JspException {
        return SelectedValueComparator.isSelected(this.getBindStatus(), value);
    }

    protected void renderFromBoolean(Boolean boundValue, TagWriter tagWriter) throws JspException {
        tagWriter.writeAttribute("value", this.processFieldValue(this.getName(), "true", this.getInputType()));
        if (boundValue.booleanValue()) {
            tagWriter.writeAttribute("checked", "checked");
        }
    }

    protected String autogenerateId() throws JspException {
        return TagIdGenerator.nextId(super.autogenerateId(), this.pageContext);
    }

    protected abstract int writeTagContent(TagWriter var1) throws JspException;

    protected abstract String getInputType();
}

