/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.FlashMap;
import org.springframework.web.servlet.FlashMapManager;
import org.springframework.web.util.UrlPathHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFlashMapManager
implements FlashMapManager {
    private static final String FLASH_MAPS_SESSION_ATTRIBUTE = DefaultFlashMapManager.class + ".FLASH_MAPS";
    private static final Log logger = LogFactory.getLog(DefaultFlashMapManager.class);
    private int flashTimeout = 180;
    private final UrlPathHelper urlPathHelper = new UrlPathHelper();

    public void setFlashMapTimeout(int flashTimeout) {
        this.flashTimeout = flashTimeout;
    }

    @Override
    public void requestStarted(HttpServletRequest request) {
        if (request.getAttribute(OUTPUT_FLASH_MAP_ATTRIBUTE) != null) {
            return;
        }
        FlashMap inputFlashMap = this.lookupFlashMap(request);
        if (inputFlashMap != null) {
            request.setAttribute(INPUT_FLASH_MAP_ATTRIBUTE, Collections.unmodifiableMap(inputFlashMap));
        }
        FlashMap outputFlashMap = new FlashMap(this.hashCode());
        request.setAttribute(OUTPUT_FLASH_MAP_ATTRIBUTE, (Object)outputFlashMap);
        this.removeExpiredFlashMaps(request);
    }

    private FlashMap lookupFlashMap(HttpServletRequest request) {
        List<FlashMap> allFlashMaps = this.retrieveFlashMaps(request, false);
        if (CollectionUtils.isEmpty(allFlashMaps)) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieved FlashMap(s): " + allFlashMaps));
        }
        ArrayList<FlashMap> result = new ArrayList<FlashMap>();
        for (FlashMap flashMap : allFlashMaps) {
            if (!this.isFlashMapForRequest(flashMap, request)) continue;
            result.add(flashMap);
        }
        if (!result.isEmpty()) {
            Collections.sort(result);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found matching FlashMap(s): " + result));
            }
            FlashMap match = (FlashMap)result.remove(0);
            allFlashMaps.remove(match);
            return match;
        }
        return null;
    }

    protected boolean isFlashMapForRequest(FlashMap flashMap, HttpServletRequest request) {
        String requestUri;
        if (flashMap.getTargetRequestPath() != null && !(requestUri = this.urlPathHelper.getRequestUri(request)).equals(flashMap.getTargetRequestPath()) && !requestUri.equals(String.valueOf(flashMap.getTargetRequestPath()) + "/")) {
            return false;
        }
        MultiValueMap<String, String> params = flashMap.getTargetRequestParams();
        for (String key : params.keySet()) {
            for (String value : (List)params.get((Object)key)) {
                if (value.equals(request.getParameter(key))) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<FlashMap> retrieveFlashMaps(HttpServletRequest request, boolean allowCreate) {
        HttpSession session = request.getSession(allowCreate);
        if (session == null) {
            return null;
        }
        CopyOnWriteArrayList allFlashMaps = (CopyOnWriteArrayList)session.getAttribute(FLASH_MAPS_SESSION_ATTRIBUTE);
        if (allFlashMaps == null && allowCreate) {
            DefaultFlashMapManager defaultFlashMapManager = this;
            synchronized (defaultFlashMapManager) {
                allFlashMaps = (List)session.getAttribute(FLASH_MAPS_SESSION_ATTRIBUTE);
                if (allFlashMaps == null) {
                    allFlashMaps = new CopyOnWriteArrayList();
                    session.setAttribute(FLASH_MAPS_SESSION_ATTRIBUTE, allFlashMaps);
                }
            }
        }
        return allFlashMaps;
    }

    private void removeExpiredFlashMaps(HttpServletRequest request) {
        List<FlashMap> allMaps = this.retrieveFlashMaps(request, false);
        if (CollectionUtils.isEmpty(allMaps)) {
            return;
        }
        ArrayList<FlashMap> expiredMaps = new ArrayList<FlashMap>();
        for (FlashMap flashMap : allMaps) {
            if (!flashMap.isExpired()) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removing expired FlashMap: " + flashMap));
            }
            expiredMaps.add(flashMap);
        }
        if (!expiredMaps.isEmpty()) {
            allMaps.removeAll(expiredMaps);
        }
    }

    @Override
    public void requestCompleted(HttpServletRequest request) {
        FlashMap flashMap = (FlashMap)request.getAttribute(OUTPUT_FLASH_MAP_ATTRIBUTE);
        if (flashMap == null) {
            throw new IllegalStateException("requestCompleted called but \"output\" FlashMap was never created");
        }
        if (!flashMap.isEmpty() && flashMap.isCreatedBy(this.hashCode())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Saving FlashMap=" + flashMap));
            }
            this.onSaveFlashMap(flashMap, request);
            this.retrieveFlashMaps(request, true).add(flashMap);
        }
    }

    protected void onSaveFlashMap(FlashMap flashMap, HttpServletRequest request) {
        String targetPath = flashMap.getTargetRequestPath();
        flashMap.setTargetRequestPath(this.decodeAndNormalizePath(targetPath, request));
        flashMap.startExpirationPeriod(this.flashTimeout);
    }

    private String decodeAndNormalizePath(String path, HttpServletRequest request) {
        if (path != null && (path = this.urlPathHelper.decodeRequestString(request, path)).charAt(0) != '/') {
            String requestUri = this.urlPathHelper.getRequestUri(request);
            path = String.valueOf(requestUri.substring(0, requestUri.lastIndexOf(47) + 1)) + path;
            path = StringUtils.cleanPath((String)path);
        }
        return path;
    }
}

