/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation.support;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.GenericCollectionTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.annotation.support.MethodArgumentNotValidException;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.support.MissingServletRequestPartException;
import org.springframework.web.multipart.support.RequestPartServletServerHttpRequest;
import org.springframework.web.servlet.mvc.method.annotation.support.AbstractMessageConverterMethodArgumentResolver;
import org.springframework.web.util.WebUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestPartMethodArgumentResolver
extends AbstractMessageConverterMethodArgumentResolver {
    public RequestPartMethodArgumentResolver(List<HttpMessageConverter<?>> messageConverters) {
        super(messageConverters);
    }

    public boolean supportsParameter(MethodParameter parameter) {
        if (parameter.hasParameterAnnotation(RequestPart.class)) {
            return true;
        }
        if (parameter.hasParameterAnnotation(RequestParam.class)) {
            return false;
        }
        if (MultipartFile.class.equals((Object)parameter.getParameterType())) {
            return true;
        }
        return "javax.servlet.http.Part".equals(parameter.getParameterType().getName());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest request, WebDataBinderFactory binderFactory) throws Exception {
        boolean isRequired;
        Object arg;
        HttpServletRequest servletRequest = (HttpServletRequest)request.getNativeRequest(HttpServletRequest.class);
        if (!this.isMultipartRequest(servletRequest)) {
            throw new MultipartException("The current request is not a multipart request.");
        }
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)WebUtils.getNativeRequest((ServletRequest)servletRequest, MultipartHttpServletRequest.class);
        String partName = this.getPartName(parameter);
        if (MultipartFile.class.equals((Object)parameter.getParameterType())) {
            Assert.notNull((Object)multipartRequest, (String)"Expected MultipartHttpServletRequest: is a MultipartResolver configured?");
            arg = multipartRequest.getFile(partName);
        } else if (this.isMultipartFileCollection(parameter)) {
            Assert.notNull((Object)multipartRequest, (String)"Expected MultipartHttpServletRequest: is a MultipartResolver configured?");
            arg = multipartRequest.getFiles(partName);
        } else if ("javax.servlet.http.Part".equals(parameter.getParameterType().getName())) {
            arg = servletRequest.getPart(partName);
        } else {
            try {
                RequestPartServletServerHttpRequest inputMessage = new RequestPartServletServerHttpRequest(servletRequest, partName);
                arg = this.readWithMessageConverters((HttpInputMessage)inputMessage, parameter, parameter.getParameterType());
                if (this.isValidationApplicable(arg, parameter)) {
                    WebDataBinder binder = binderFactory.createBinder(request, arg, partName);
                    binder.validate();
                    BindingResult bindingResult = binder.getBindingResult();
                    if (bindingResult.hasErrors()) {
                        throw new MethodArgumentNotValidException(parameter, bindingResult);
                    }
                }
            }
            catch (MissingServletRequestPartException missingServletRequestPartException) {
                arg = null;
            }
        }
        RequestPart annot = (RequestPart)parameter.getParameterAnnotation(RequestPart.class);
        boolean bl = isRequired = annot != null ? annot.required() : true;
        if (arg == null && isRequired) {
            throw new MissingServletRequestPartException(partName);
        }
        return arg;
    }

    private boolean isMultipartRequest(HttpServletRequest request) {
        if (!"post".equals(request.getMethod().toLowerCase())) {
            return false;
        }
        String contentType = request.getContentType();
        return contentType != null && contentType.toLowerCase().startsWith("multipart/");
    }

    private String getPartName(MethodParameter parameter) {
        String partName;
        RequestPart annot = (RequestPart)parameter.getParameterAnnotation(RequestPart.class);
        String string = partName = annot != null ? annot.value() : "";
        if (partName.length() == 0) {
            partName = parameter.getParameterName();
            Assert.notNull((Object)partName, (String)("Request part name for argument type [" + parameter.getParameterType().getName() + "] not available, and parameter name information not found in class file either."));
        }
        return partName;
    }

    private boolean isMultipartFileCollection(MethodParameter parameter) {
        Class valueType;
        Class paramType = parameter.getParameterType();
        return (Collection.class.equals((Object)paramType) || List.class.isAssignableFrom(paramType)) && (valueType = GenericCollectionTypeResolver.getCollectionParameterType((MethodParameter)parameter)) != null && valueType.equals(MultipartFile.class);
    }

    protected boolean isValidationApplicable(Object argument, MethodParameter parameter) {
        Annotation[] annotations;
        if (argument == null) {
            return false;
        }
        Annotation[] annotationArray = annotations = parameter.getParameterAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annot = annotationArray[n2];
            if ("Valid".equals(annot.annotationType().getSimpleName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

