/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.AbstractHandlerMethodMapping;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RequestMappingInfoHandlerMapping
extends AbstractHandlerMethodMapping<RequestMappingInfo> {
    @Override
    protected Set<String> getMappingPathPatterns(RequestMappingInfo info) {
        return info.getPatternsCondition().getPatterns();
    }

    @Override
    protected RequestMappingInfo getMatchingMapping(RequestMappingInfo info, HttpServletRequest request) {
        return info.getMatchingCondition(request);
    }

    @Override
    protected Comparator<RequestMappingInfo> getMappingComparator(final HttpServletRequest request) {
        return new Comparator<RequestMappingInfo>(){

            @Override
            public int compare(RequestMappingInfo info1, RequestMappingInfo info2) {
                return info1.compareTo(info2, request);
            }
        };
    }

    @Override
    protected void handleMatch(RequestMappingInfo info, String lookupPath, HttpServletRequest request) {
        super.handleMatch(info, lookupPath, request);
        String pattern = info.getPatternsCondition().getPatterns().iterator().next();
        request.setAttribute(BEST_MATCHING_PATTERN_ATTRIBUTE, (Object)pattern);
        Map uriTemplateVariables = this.getPathMatcher().extractUriTemplateVariables(pattern, lookupPath);
        request.setAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE, (Object)uriTemplateVariables);
        if (!info.getProducesCondition().getProducibleMediaTypes().isEmpty()) {
            Set<MediaType> mediaTypes = info.getProducesCondition().getProducibleMediaTypes();
            request.setAttribute(PRODUCIBLE_MEDIA_TYPES_ATTRIBUTE, mediaTypes);
        }
    }

    @Override
    protected HandlerMethod handleNoMatch(Set<RequestMappingInfo> requestMappingInfos, String lookupPath, HttpServletRequest request) throws ServletException {
        HashSet<String> allowedMethods = new HashSet<String>(6);
        HashSet<MediaType> consumableMediaTypes = new HashSet<MediaType>();
        HashSet<MediaType> producibleMediaTypes = new HashSet<MediaType>();
        for (RequestMappingInfo info : requestMappingInfos) {
            if (info.getPatternsCondition().getMatchingCondition(request) == null) continue;
            if (info.getMethodsCondition().getMatchingCondition(request) == null) {
                for (RequestMethod method : info.getMethodsCondition().getMethods()) {
                    allowedMethods.add(method.name());
                }
            }
            if (info.getConsumesCondition().getMatchingCondition(request) == null) {
                consumableMediaTypes.addAll(info.getConsumesCondition().getConsumableMediaTypes());
            }
            if (info.getProducesCondition().getMatchingCondition(request) != null) continue;
            producibleMediaTypes.addAll(info.getProducesCondition().getProducibleMediaTypes());
        }
        if (!allowedMethods.isEmpty()) {
            throw new HttpRequestMethodNotSupportedException(request.getMethod(), allowedMethods);
        }
        if (!consumableMediaTypes.isEmpty()) {
            MediaType contentType = null;
            if (StringUtils.hasLength((String)request.getContentType())) {
                contentType = MediaType.parseMediaType((String)request.getContentType());
            }
            throw new HttpMediaTypeNotSupportedException(contentType, new ArrayList(consumableMediaTypes));
        }
        if (!producibleMediaTypes.isEmpty()) {
            throw new HttpMediaTypeNotAcceptableException(new ArrayList(producibleMediaTypes));
        }
        return null;
    }
}

