/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.handler;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.core.Ordered;
import org.springframework.core.log.LogDelegateFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.reactive.CorsConfigurationSource;
import org.springframework.web.cors.reactive.CorsProcessor;
import org.springframework.web.cors.reactive.CorsUtils;
import org.springframework.web.cors.reactive.DefaultCorsProcessor;
import org.springframework.web.cors.reactive.UrlBasedCorsConfigurationSource;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.accept.ApiVersionStrategy;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebHandler;
import org.springframework.web.util.pattern.PathPatternParser;
import reactor.core.publisher.Mono;

public abstract class AbstractHandlerMapping
extends ApplicationObjectSupport
implements HandlerMapping,
Ordered,
BeanNameAware {
    private static final WebHandler NO_OP_HANDLER = exchange2 -> Mono.empty();
    protected final Log mappingsLogger = LogDelegateFactory.getHiddenLog((String)(HandlerMapping.class.getName() + ".Mappings"));
    private final PathPatternParser patternParser = new PathPatternParser();
    private @Nullable CorsConfigurationSource corsConfigurationSource;
    private CorsProcessor corsProcessor = new DefaultCorsProcessor();
    private @Nullable ApiVersionStrategy apiVersionStrategy;
    private int order = Integer.MAX_VALUE;
    private @Nullable String beanName;

    public void setUseCaseSensitiveMatch(boolean caseSensitiveMatch) {
        this.patternParser.setCaseSensitive(caseSensitiveMatch);
    }

    public PathPatternParser getPathPatternParser() {
        return this.patternParser;
    }

    public void setCorsConfigurations(Map<String, CorsConfiguration> corsConfigurations) {
        Assert.notNull(corsConfigurations, (String)"corsConfigurations must not be null");
        if (!corsConfigurations.isEmpty()) {
            UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource(this.patternParser);
            source.setCorsConfigurations(corsConfigurations);
            this.corsConfigurationSource = source;
        } else {
            this.corsConfigurationSource = null;
        }
    }

    public void setCorsConfigurationSource(CorsConfigurationSource corsConfigurationSource) {
        Assert.notNull((Object)corsConfigurationSource, (String)"corsConfigurationSource must not be null");
        this.corsConfigurationSource = corsConfigurationSource;
    }

    public void setCorsProcessor(CorsProcessor corsProcessor) {
        Assert.notNull((Object)corsProcessor, (String)"CorsProcessor must not be null");
        this.corsProcessor = corsProcessor;
    }

    public CorsProcessor getCorsProcessor() {
        return this.corsProcessor;
    }

    public void setApiVersionStrategy(@Nullable ApiVersionStrategy strategy) {
        this.apiVersionStrategy = strategy;
    }

    public @Nullable ApiVersionStrategy getApiVersionStrategy() {
        return this.apiVersionStrategy;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    protected String formatMappingName() {
        return this.beanName != null ? "'" + this.beanName + "'" : "<unknown>";
    }

    @Override
    public Mono<Object> getHandler(ServerWebExchange exchange2) {
        this.initApiVersion(exchange2);
        return this.getHandlerInternal(exchange2).map(handler -> {
            Comparable version;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(exchange2.getLogPrefix() + "Mapped to " + String.valueOf(handler)));
            }
            ServerHttpRequest request = exchange2.getRequest();
            if (this.hasCorsConfigurationSource(handler) || CorsUtils.isPreFlightRequest((ServerHttpRequest)request)) {
                CorsConfiguration config = this.corsConfigurationSource != null ? this.corsConfigurationSource.getCorsConfiguration(exchange2) : null;
                CorsConfiguration handlerConfig = this.getCorsConfiguration(handler, exchange2);
                CorsConfiguration corsConfiguration = config = config != null ? config.combine(handlerConfig) : handlerConfig;
                if (config != null) {
                    config.validateAllowCredentials();
                    config.validateAllowPrivateNetwork();
                }
                if (!this.corsProcessor.process(config, exchange2) || CorsUtils.isPreFlightRequest((ServerHttpRequest)request)) {
                    return NO_OP_HANDLER;
                }
            }
            if (this.getApiVersionStrategy() != null && (version = (Comparable)exchange2.getAttribute(API_VERSION_ATTRIBUTE)) != null) {
                this.getApiVersionStrategy().handleDeprecations(version, handler, exchange2);
            }
            return handler;
        });
    }

    private void initApiVersion(ServerWebExchange exchange2) {
        Comparable<?> version;
        if (this.apiVersionStrategy != null && (version = (Comparable<?>)exchange2.getAttribute(API_VERSION_ATTRIBUTE)) == null && (version = this.apiVersionStrategy.resolveParseAndValidateVersion(exchange2)) != null) {
            exchange2.getAttributes().put(API_VERSION_ATTRIBUTE, version);
        }
    }

    protected abstract Mono<?> getHandlerInternal(ServerWebExchange var1);

    protected boolean hasCorsConfigurationSource(Object handler) {
        return handler instanceof CorsConfigurationSource || this.corsConfigurationSource != null;
    }

    protected @Nullable CorsConfiguration getCorsConfiguration(Object handler, ServerWebExchange exchange2) {
        if (handler instanceof CorsConfigurationSource) {
            CorsConfigurationSource ccs = (CorsConfigurationSource)handler;
            return ccs.getCorsConfiguration(exchange2);
        }
        return null;
    }
}

