/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.net.URI;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.web.reactive.function.client.WebClientException;

public class WebClientRequestException
extends WebClientException {
    private static final long serialVersionUID = -5139991985321385005L;
    private final HttpMethod method;
    private final URI uri;
    private final HttpHeaders headers;

    public WebClientRequestException(Throwable ex, HttpMethod method, URI uri, HttpHeaders headers) {
        super(ex.getMessage(), ex);
        this.method = method;
        this.uri = uri;
        this.headers = WebClientRequestException.copy(headers);
    }

    private static HttpHeaders copy(HttpHeaders headers) {
        HttpHeaders result = new HttpHeaders();
        for (Map.Entry entry : headers.headerSet()) {
            for (String value : (List)entry.getValue()) {
                result.add((String)entry.getKey(), value);
            }
        }
        return result;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public URI getUri() {
        return this.uri;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }
}

