/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.config;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;

public class PathMatchConfigurer {
    private @Nullable Boolean caseSensitiveMatch;
    private @Nullable Map<String, Predicate<Class<?>>> pathPrefixes;

    public PathMatchConfigurer setUseCaseSensitiveMatch(Boolean caseSensitiveMatch) {
        this.caseSensitiveMatch = caseSensitiveMatch;
        return this;
    }

    public PathMatchConfigurer addPathPrefix(String prefix, Predicate<Class<?>> predicate) {
        if (this.pathPrefixes == null) {
            this.pathPrefixes = new LinkedHashMap();
        }
        this.pathPrefixes.put(prefix, predicate);
        return this;
    }

    protected @Nullable Boolean isUseCaseSensitiveMatch() {
        return this.caseSensitiveMatch;
    }

    protected @Nullable Map<String, Predicate<Class<?>>> getPathPrefixes() {
        return this.pathPrefixes;
    }
}

