/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.condition;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.reactive.result.condition.AbstractNameValueExpression;
import org.springframework.web.reactive.result.condition.AbstractRequestCondition;
import org.springframework.web.reactive.result.condition.NameValueExpression;
import org.springframework.web.server.ServerWebExchange;

public final class ParamsRequestCondition
extends AbstractRequestCondition<ParamsRequestCondition> {
    private final Set<ParamExpression> expressions;

    public ParamsRequestCondition(String ... params) {
        this.expressions = ParamsRequestCondition.parseExpressions(params);
    }

    private static Set<ParamExpression> parseExpressions(String ... params) {
        if (ObjectUtils.isEmpty((Object[])params)) {
            return Collections.emptySet();
        }
        LinkedHashSet result = CollectionUtils.newLinkedHashSet((int)params.length);
        for (String param : params) {
            result.add(new ParamExpression(param));
        }
        return result;
    }

    private ParamsRequestCondition(Set<ParamExpression> conditions) {
        this.expressions = conditions;
    }

    public Set<NameValueExpression<String>> getExpressions() {
        return new LinkedHashSet<NameValueExpression<String>>(this.expressions);
    }

    @Override
    protected Collection<ParamExpression> getContent() {
        return this.expressions;
    }

    @Override
    protected String getToStringInfix() {
        return " && ";
    }

    @Override
    public ParamsRequestCondition combine(ParamsRequestCondition other) {
        if (other.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return other;
        }
        LinkedHashSet<ParamExpression> set = new LinkedHashSet<ParamExpression>(this.expressions);
        set.addAll(other.expressions);
        return new ParamsRequestCondition(set);
    }

    @Override
    @Nullable
    public ParamsRequestCondition getMatchingCondition(ServerWebExchange exchange2) {
        for (ParamExpression expression : this.expressions) {
            if (expression.match(exchange2)) continue;
            return null;
        }
        return this;
    }

    @Override
    public int compareTo(ParamsRequestCondition other, ServerWebExchange exchange2) {
        int result = other.expressions.size() - this.expressions.size();
        if (result != 0) {
            return result;
        }
        return (int)(this.getValueMatchCount(other.expressions) - this.getValueMatchCount(this.expressions));
    }

    private long getValueMatchCount(Set<ParamExpression> expressions) {
        long count = 0L;
        for (ParamExpression e : expressions) {
            if (e.getValue() == null || e.isNegated()) continue;
            ++count;
        }
        return count;
    }

    static class ParamExpression
    extends AbstractNameValueExpression<String> {
        ParamExpression(String expression) {
            super(expression);
        }

        @Override
        protected boolean isCaseSensitiveName() {
            return true;
        }

        @Override
        protected String parseValue(String valueExpression) {
            return valueExpression;
        }

        @Override
        protected boolean matchName(ServerWebExchange exchange2) {
            return exchange2.getRequest().getQueryParams().containsKey((Object)this.name);
        }

        @Override
        protected boolean matchValue(ServerWebExchange exchange2) {
            return this.value != null && ((String)this.value).equals(exchange2.getRequest().getQueryParams().getFirst((Object)this.name));
        }
    }
}

